/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupExtEntity;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.tubemq.InlongTubeMQDTO;
import org.apache.inlong.manager.pojo.group.tubemq.InlongTubeMQInfo;
import org.apache.inlong.manager.pojo.group.tubemq.InlongTubeMQRequest;
import org.apache.inlong.manager.pojo.group.tubemq.InlongTubeMQTopicInfo;
import org.apache.inlong.manager.service.group.AbstractGroupOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupOperator4TubeMQ
extends AbstractGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupOperator4TubeMQ.class);

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType);
    }

    @Override
    public String getMQType() {
        return "TUBEMQ";
    }

    public InlongTubeMQInfo getFromEntity(InlongGroupEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongTubeMQInfo groupInfo = new InlongTubeMQInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)groupInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            InlongTubeMQDTO dto = InlongTubeMQDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)groupInfo);
        }
        return groupInfo;
    }

    @Override
    protected void setTargetEntity(InlongGroupRequest request, InlongGroupEntity targetEntity) {
        InlongTubeMQRequest tubeMQRequest = (InlongTubeMQRequest)request;
        try {
            InlongTubeMQDTO dto = InlongTubeMQDTO.getFromRequest((InlongGroupRequest)tubeMQRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    @Override
    public InlongGroupTopicInfo getTopic(InlongGroupInfo groupInfo) {
        InlongTubeMQTopicInfo topicInfo = new InlongTubeMQTopicInfo();
        topicInfo.setTopic(groupInfo.getMqResource());
        return topicInfo;
    }

    @Override
    public InlongGroupTopicInfo getBackupTopic(InlongGroupInfo groupInfo) {
        InlongTubeMQTopicInfo topicInfo = new InlongTubeMQTopicInfo();
        InlongGroupExtEntity extEntity = this.groupExtMapper.selectByUniqueKey(groupInfo.getInlongGroupId(), "backup_mq_resource");
        if (extEntity != null && StringUtils.isNotBlank((CharSequence)extEntity.getKeyValue())) {
            topicInfo.setTopic(extEntity.getKeyValue());
        } else {
            topicInfo.setTopic(groupInfo.getMqResource());
        }
        return topicInfo;
    }
}

