/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.heartbeat;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.heartbeat.AbstractHeartbeatManager;
import org.apache.inlong.common.heartbeat.ComponentHeartbeat;
import org.apache.inlong.common.heartbeat.HeartbeatMsg;
import org.apache.inlong.manager.common.enums.ClusterStatus;
import org.apache.inlong.manager.common.enums.NodeStatus;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterNodeEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.service.cluster.InlongClusterOperator;
import org.apache.inlong.manager.service.cluster.InlongClusterOperatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeartbeatManager
implements AbstractHeartbeatManager {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatManager.class);
    private static final String AUTO_REGISTERED = "auto registered";
    private Cache<ComponentHeartbeat, HeartbeatMsg> heartbeatCache;
    private LoadingCache<ComponentHeartbeat, ClusterInfo> clusterInfoCache;
    @Autowired
    private InlongClusterOperatorFactory clusterOperatorFactory;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private InlongClusterNodeEntityMapper clusterNodeMapper;

    @PostConstruct
    public void init() {
        long expireTime = (long)this.heartbeatInterval() * 2L;
        Scheduler evictScheduler = Scheduler.forScheduledExecutorService((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
        this.heartbeatCache = Caffeine.newBuilder().scheduler(evictScheduler).expireAfterAccess(expireTime, TimeUnit.SECONDS).removalListener((k, msg, c) -> {
            if ((c.wasEvicted() || c == RemovalCause.EXPLICIT) && msg != null) {
                this.evictClusterNode((HeartbeatMsg)msg);
            }
        }).build();
        this.clusterInfoCache = Caffeine.newBuilder().expireAfterAccess(expireTime * 2L, TimeUnit.SECONDS).build(this::fetchCluster);
    }

    public void reportHeartbeat(HeartbeatMsg heartbeat) {
        ComponentHeartbeat componentHeartbeat = heartbeat.componentHeartbeat();
        ClusterInfo clusterInfo = (ClusterInfo)this.clusterInfoCache.get((Object)componentHeartbeat);
        if (clusterInfo == null) {
            log.error("not found any cluster by name={} and type={}", (Object)componentHeartbeat.getClusterName(), (Object)componentHeartbeat.getComponentType());
            return;
        }
        HeartbeatMsg lastHeartbeat = (HeartbeatMsg)this.heartbeatCache.getIfPresent((Object)componentHeartbeat);
        String[] ports = heartbeat.getPort().split(",");
        String[] ips = heartbeat.getIp().split(",");
        String protocolType = heartbeat.getProtocolType();
        String[] protocolTypes = null;
        if (StringUtils.isNotBlank((CharSequence)protocolType) && ports.length > 1 && (protocolTypes = protocolType.split(",")).length < ports.length) {
            protocolTypes = null;
        }
        int handlerNum = 0;
        for (int i = 0; i < ports.length; ++i) {
            HeartbeatMsg heartbeatMsg = (HeartbeatMsg)JsonUtils.parseObject((byte[])JsonUtils.toJsonByte((Object)heartbeat), HeartbeatMsg.class);
            assert (heartbeatMsg != null);
            heartbeatMsg.setPort(ports[i].trim());
            heartbeatMsg.setIp(ips[i].trim());
            if (protocolTypes != null) {
                heartbeatMsg.setProtocolType(protocolTypes[i]);
            } else {
                heartbeatMsg.setProtocolType(protocolType);
            }
            if (lastHeartbeat != null) continue;
            InlongClusterNodeEntity clusterNode = this.getClusterNode(clusterInfo, heartbeatMsg);
            if (clusterNode == null) {
                handlerNum += this.insertClusterNode(clusterInfo, heartbeatMsg, clusterInfo.getCreator());
                continue;
            }
            handlerNum += this.updateClusterNode(clusterNode);
        }
        if (lastHeartbeat == null && handlerNum == ports.length) {
            this.heartbeatCache.put((Object)componentHeartbeat, (Object)heartbeat);
        }
    }

    private void evictClusterNode(HeartbeatMsg heartbeat) {
        log.debug("evict cluster node");
        ComponentHeartbeat componentHeartbeat = heartbeat.componentHeartbeat();
        ClusterInfo clusterInfo = (ClusterInfo)this.clusterInfoCache.getIfPresent((Object)componentHeartbeat);
        if (clusterInfo == null) {
            log.error("not found any cluster by name={} and type={}", (Object)componentHeartbeat.getClusterName(), (Object)componentHeartbeat.getComponentType());
            return;
        }
        String[] ports = heartbeat.getPort().split(",");
        String[] ips = heartbeat.getIp().split(",");
        String protocolType = heartbeat.getProtocolType();
        String[] protocolTypes = null;
        if (StringUtils.isNotBlank((CharSequence)protocolType) && ports.length > 1 && (protocolTypes = protocolType.split(",")).length < ports.length) {
            protocolTypes = null;
        }
        for (int i = 0; i < ports.length; ++i) {
            HeartbeatMsg heartbeatMsg = (HeartbeatMsg)JsonUtils.parseObject((byte[])JsonUtils.toJsonByte((Object)heartbeat), HeartbeatMsg.class);
            assert (heartbeatMsg != null);
            heartbeatMsg.setPort(ports[i].trim());
            heartbeatMsg.setIp(ips[i].trim());
            if (protocolTypes != null) {
                heartbeatMsg.setProtocolType(protocolTypes[i]);
            } else {
                heartbeatMsg.setProtocolType(protocolType);
            }
            InlongClusterNodeEntity clusterNode = this.getClusterNode(clusterInfo, heartbeatMsg);
            if (clusterNode == null) {
                log.error("not found any cluster node by type={}, ip={}, port={}", new Object[]{heartbeat.getComponentType(), heartbeat.getIp(), heartbeat.getPort()});
                return;
            }
            clusterNode.setStatus(Integer.valueOf(NodeStatus.HEARTBEAT_TIMEOUT.getStatus()));
            this.clusterNodeMapper.updateById(clusterNode);
        }
    }

    private InlongClusterNodeEntity getClusterNode(ClusterInfo clusterInfo, HeartbeatMsg heartbeat) {
        ClusterNodeRequest nodeRequest = new ClusterNodeRequest();
        nodeRequest.setParentId(clusterInfo.getId());
        nodeRequest.setType(heartbeat.getComponentType());
        nodeRequest.setIp(heartbeat.getIp());
        nodeRequest.setPort(Integer.valueOf(heartbeat.getPort()));
        nodeRequest.setProtocolType(heartbeat.getProtocolType());
        return this.clusterNodeMapper.selectByUniqueKey(nodeRequest);
    }

    private int insertClusterNode(ClusterInfo clusterInfo, HeartbeatMsg heartbeat, String creator) {
        InlongClusterNodeEntity clusterNode = new InlongClusterNodeEntity();
        clusterNode.setParentId(clusterInfo.getId());
        clusterNode.setType(heartbeat.getComponentType());
        clusterNode.setIp(heartbeat.getIp());
        clusterNode.setPort(Integer.valueOf(heartbeat.getPort()));
        clusterNode.setProtocolType(heartbeat.getProtocolType());
        clusterNode.setStatus(Integer.valueOf(ClusterStatus.NORMAL.getStatus()));
        clusterNode.setCreator(creator);
        clusterNode.setModifier(creator);
        clusterNode.setDescription(AUTO_REGISTERED);
        return this.clusterNodeMapper.insertOnDuplicateKeyUpdate(clusterNode);
    }

    private int updateClusterNode(InlongClusterNodeEntity clusterNode) {
        clusterNode.setStatus(Integer.valueOf(ClusterStatus.NORMAL.getStatus()));
        return this.clusterNodeMapper.updateById(clusterNode);
    }

    private ClusterInfo fetchCluster(ComponentHeartbeat componentHeartbeat) {
        String clusterName = componentHeartbeat.getClusterName();
        String type = componentHeartbeat.getComponentType();
        String clusterTag = componentHeartbeat.getClusterTag();
        Preconditions.checkNotNull((Object)clusterTag, (String)"cluster tag cannot be null");
        Preconditions.checkNotNull((Object)type, (String)"cluster type cannot be null");
        Preconditions.checkNotNull((Object)clusterName, (String)"cluster name cannot be null");
        InlongClusterEntity entity = this.clusterMapper.selectByNameAndType(clusterName, type);
        if (null != entity) {
            InlongClusterOperator operator = this.clusterOperatorFactory.getInstance(entity.getType());
            return operator.getFromEntity(entity);
        }
        InlongClusterEntity cluster = new InlongClusterEntity();
        cluster.setName(clusterName);
        cluster.setType(type);
        cluster.setClusterTags(clusterTag);
        String inCharges = componentHeartbeat.getInCharges();
        if (StringUtils.isBlank((CharSequence)inCharges)) {
            inCharges = "admin";
        }
        String creator = inCharges.split(",")[0];
        cluster.setInCharges(inCharges);
        cluster.setCreator(creator);
        cluster.setModifier(creator);
        cluster.setStatus(Integer.valueOf(ClusterStatus.NORMAL.getStatus()));
        cluster.setDescription(AUTO_REGISTERED);
        this.clusterMapper.insertOnDuplicateKeyUpdate(cluster);
        InlongClusterOperator operator = this.clusterOperatorFactory.getInstance(cluster.getType());
        ClusterInfo clusterInfo = operator.getFromEntity(cluster);
        log.debug("success to fetch cluster for heartbeat: {}", (Object)componentHeartbeat);
        return clusterInfo;
    }

    public Cache<ComponentHeartbeat, HeartbeatMsg> getHeartbeatCache() {
        return this.heartbeatCache;
    }

    public LoadingCache<ComponentHeartbeat, ClusterInfo> getClusterInfoCache() {
        return this.clusterInfoCache;
    }
}

