/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import java.util.List;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupUtils;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.stream.InlongStreamProcessService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitGroupCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(InitGroupCompleteListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamProcessService streamProcessService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute InitGroupCompleteListener for groupId={}", (Object)groupId);
        InlongGroupInfo groupInfo = form.getGroupInfo();
        String operator = context.getOperator();
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_SUCCESSFUL.getCode(), operator);
        if (InlongGroupUtils.isBatchTask((InlongGroupInfo)form.getGroupInfo())) {
            this.groupService.updateStatus(groupId, GroupStatus.FINISH.getCode(), operator);
        }
        InlongGroupEntity existGroup = this.groupMapper.selectByGroupId(groupId);
        InlongGroupRequest updateGroupRequest = groupInfo.genRequest();
        updateGroupRequest.setVersion(existGroup.getVersion());
        this.groupService.update(updateGroupRequest, operator);
        List streamList = form.getStreamInfos();
        for (InlongStreamInfo streamInfo : streamList) {
            this.streamProcessService.startProcess(groupId, streamInfo.getInlongStreamId(), operator, false);
        }
        log.info("success to execute InitGroupCompleteListener for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

