/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.queue;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamQueueResourceListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(StreamQueueResourceListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private QueueResourceOperatorFactory queueOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (!(processForm instanceof StreamResourceProcessForm)) {
            return false;
        }
        StreamResourceProcessForm streamProcessForm = (StreamResourceProcessForm)processForm;
        return InlongConstants.STANDARD_MODE.equals(streamProcessForm.getGroupInfo().getLightweight());
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        StreamResourceProcessForm streamProcessForm = (StreamResourceProcessForm)context.getProcessForm();
        String groupId = streamProcessForm.getInlongGroupId();
        InlongStreamInfo streamInfo = streamProcessForm.getStreamInfo();
        if (streamInfo == null) {
            String msg = "inlong stream cannot be null in StreamResourceProcessForm with groupId=" + groupId;
            log.error(msg);
            throw new WorkflowListenerException(msg);
        }
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            String msg = "inlong group not found with groupId=" + groupId;
            log.error(msg);
            throw new WorkflowListenerException(msg);
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(groupInfo.getEnableCreateResource())) {
            log.warn("skip to execute StreamQueueResourceListener as disable create resource for groupId={}", (Object)groupId);
            return ListenerResult.success((String)"skip - disable create resource");
        }
        QueueResourceOperator queueOperator = this.queueOperatorFactory.getInstance(groupInfo.getMqType());
        GroupOperateType operateType = streamProcessForm.getGroupOperateType();
        String operator = context.getOperator();
        switch (operateType) {
            case INIT: {
                queueOperator.createQueueForStream(groupInfo, streamInfo, operator);
                break;
            }
            case DELETE: {
                queueOperator.deleteQueueForStream(groupInfo, streamInfo, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
        log.info("success to execute StreamQueueResourceListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        return ListenerResult.success((String)"success");
    }
}

