/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node;

import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.service.node.DataNodeOperator;
import org.apache.inlong.manager.service.node.DataNodeOperatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataNodeOperateHelper {
    private static final Logger log = LoggerFactory.getLogger(DataNodeOperateHelper.class);
    @Autowired
    private DataNodeEntityMapper dataNodeMapper;
    @Autowired
    private DataNodeOperatorFactory operatorFactory;

    public DataNodeInfo getDataNodeInfo(String nodeName, String nodeType) {
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(nodeName, nodeType);
        if (entity == null) {
            String errMsg = String.format("data node not found by name=%s, type=%s", nodeName, nodeType);
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(nodeType);
        DataNodeInfo dataNodeInfo = dataNodeOperator.getFromEntity(entity);
        log.debug("success to get data node info by name={}, type={}", (Object)nodeName, (Object)nodeType);
        return dataNodeInfo;
    }
}

