/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.service.node.DataNodeOperator;
import org.apache.inlong.manager.service.node.DataNodeOperatorFactory;
import org.apache.inlong.manager.service.node.DataNodeService;
import org.apache.inlong.manager.service.resource.sink.hive.HiveJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    @Autowired
    private DataNodeEntityMapper dataNodeMapper;
    @Autowired
    private DataNodeOperatorFactory operatorFactory;

    @Override
    public Integer save(DataNodeRequest request, String operator) {
        String type;
        String name = request.getName();
        DataNodeEntity existEntity = this.dataNodeMapper.selectByUniqueKey(name, type = request.getType());
        if (existEntity != null) {
            String errMsg = String.format("data node already exist for name=%s type=%s)", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(request.getType());
        int id = dataNodeOperator.saveOpt(request, operator);
        LOGGER.debug("success to save data node={}", (Object)request);
        return id;
    }

    @Override
    public DataNodeInfo get(Integer id) {
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("data node not found by id={}", (Object)id);
            throw new BusinessException("data node not found");
        }
        String dataNodeType = entity.getType();
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(dataNodeType);
        DataNodeInfo dataNodeInfo = dataNodeOperator.getFromEntity(entity);
        LOGGER.debug("success to get data node info by id={}", (Object)id);
        return dataNodeInfo;
    }

    @Override
    public DataNodeInfo get(String name, String type) {
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(name, type);
        if (entity == null) {
            String errMsg = String.format("data node not found by name=%s, type=%s", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(type);
        DataNodeInfo dataNodeInfo = dataNodeOperator.getFromEntity(entity);
        LOGGER.debug("success to get data node by name={} type={}", (Object)name, (Object)type);
        return dataNodeInfo;
    }

    @Override
    public PageResult<DataNodeInfo> list(DataNodePageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.dataNodeMapper.selectByCondition(request);
        List list = entityPage.stream().map(entity -> {
            DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(entity.getType());
            return dataNodeOperator.getFromEntity((DataNodeEntity)entity);
        }).collect(Collectors.toList());
        PageResult pageResult = new PageResult(list, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        LOGGER.debug("success to list data node by {}", (Object)request);
        return pageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(DataNodeRequest request, String operator) {
        LOGGER.info("begin to update data node by id: {}", (Object)request);
        String name = request.getName();
        String type = request.getType();
        DataNodeEntity existEntity = this.dataNodeMapper.selectByUniqueKey(name, type);
        Integer id = request.getId();
        if (existEntity != null && !existEntity.getId().equals(id)) {
            String errMsg = String.format("data node already exist for name=%s, type=%s", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(request.getType());
        dataNodeOperator.updateOpt(request, operator);
        LOGGER.info("success to update data node={}", (Object)request);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public UpdateResult updateByKey(DataNodeRequest request, String operator) {
        LOGGER.info("begin to update data node by key: {}", (Object)request);
        String name = request.getName();
        String type = request.getType();
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(name, type);
        if (entity == null) {
            String errMsg = String.format("data node not found by name=%s, type=%s", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        request.setId(entity.getId());
        Boolean result = this.update(request, operator);
        LOGGER.info("success to update data node by key: {}", (Object)request);
        return new UpdateResult(entity.getId(), result, Integer.valueOf(request.getVersion() + 1));
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null || entity.getIsDeleted() > InlongConstants.UN_DELETED) {
            LOGGER.error("data node not found or was already deleted for id={}", (Object)id);
            return false;
        }
        return this.delete(entity, operator);
    }

    private Boolean delete(DataNodeEntity entity, String operator) {
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.dataNodeMapper.updateById(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("data node has already updated, data node name={}, type={}, current version ={}", new Object[]{entity.getName(), entity.getType(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete data node by id={}, name={}", (Object)entity.getId(), (Object)entity.getName());
        return true;
    }

    @Override
    public Boolean deleteByKey(String name, String type, String operator) {
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(name, type);
        if (entity == null || entity.getIsDeleted() > InlongConstants.UN_DELETED) {
            LOGGER.error("data node not found or was already deleted for name={}", (Object)name);
            return false;
        }
        return this.delete(entity, operator);
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        LOGGER.info("begin test connection for: {}", (Object)request);
        String type = request.getType();
        Boolean result = false;
        if ("HIVE".equals(type)) {
            result = this.testHiveConnection(request);
        }
        LOGGER.info("connection [{}] for: {}", (Object)(result != false ? "success" : "failed"), (Object)request);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean testHiveConnection(DataNodeRequest request) {
        String url = request.getUrl();
        Preconditions.checkNotNull((Object)url, (String)"connection url cannot be empty");
        try (Connection ignored = HiveJdbcUtils.getConnection(url, request.getUsername(), request.getToken());){
            LOGGER.info("hive connection not null - connection success");
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("hive connection failed: {}", (Object)e.getMessage());
            return false;
        }
    }
}

