/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.iceberg;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeDTO;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeInfo;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcebergDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "ICEBERG";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        IcebergDataNodeInfo icebergDataNodeInfo = new IcebergDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)icebergDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            IcebergDataNodeDTO dto = IcebergDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)icebergDataNodeInfo);
        }
        LOGGER.debug("success to get iceberg data node from entity");
        return icebergDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        IcebergDataNodeRequest icebergDataNodeRequest = (IcebergDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)icebergDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            IcebergDataNodeDTO dto = IcebergDataNodeDTO.getFromRequest((IcebergDataNodeRequest)icebergDataNodeRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            LOGGER.error("failed to set entity for iceberg data node: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }
}

