/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.greenplum;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumSink;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumSinkDTO;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GreenplumSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreenplumSinkOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "GREENPLUM".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "GREENPLUM";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        Preconditions.checkTrue((boolean)this.getSinkType().equals(request.getSinkType()), (String)(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType()));
        GreenplumSinkRequest sinkRequest = (GreenplumSinkRequest)request;
        try {
            GreenplumSinkDTO dto = GreenplumSinkDTO.getFromRequest((GreenplumSinkRequest)sinkRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            LOGGER.error("parsing json string to sink info failed", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED.getMessage());
        }
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        GreenplumSink sink = new GreenplumSink();
        if (entity == null) {
            return sink;
        }
        GreenplumSinkDTO dto = GreenplumSinkDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = super.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }
}

