/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamTransformEntity;
import org.apache.inlong.manager.dao.entity.StreamTransformFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamTransformEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamTransformFieldEntityMapper;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.DeleteTransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.service.group.GroupCheckService;
import org.apache.inlong.manager.service.transform.StreamTransformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StreamTransformServiceImpl
implements StreamTransformService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamTransformServiceImpl.class);
    @Autowired
    protected StreamTransformEntityMapper transformMapper;
    @Autowired
    protected StreamTransformFieldEntityMapper transformFieldMapper;
    @Autowired
    protected GroupCheckService groupCheckService;

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer save(TransformRequest request, String operator) {
        LOGGER.info("begin to save transform info: {}", (Object)request);
        this.checkParams(request);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String transformName = request.getTransformName();
        this.groupCheckService.checkGroupStatus(groupId, operator);
        List transformEntities = this.transformMapper.selectByRelatedId(groupId, streamId, transformName);
        if (CollectionUtils.isNotEmpty((Collection)transformEntities)) {
            String err = "stream transform already exists with groupId=%s, streamId=%s, transformName=%s";
            throw new BusinessException(String.format(err, groupId, streamId, transformName));
        }
        StreamTransformEntity transformEntity = (StreamTransformEntity)CommonBeanUtils.copyProperties((Object)request, StreamTransformEntity::new);
        transformEntity.setCreator(operator);
        transformEntity.setModifier(operator);
        this.transformMapper.insert(transformEntity);
        this.saveFieldOpt(transformEntity, request.getFieldList());
        return transformEntity.getId();
    }

    @Override
    public List<TransformResponse> listTransform(String groupId, String streamId) {
        LOGGER.info("begin to fetch transform info by groupId={} and streamId={} ", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        List entityList = this.transformMapper.selectByRelatedId(groupId, streamId, null);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Collections.emptyList();
        }
        List transformIds = entityList.stream().map(StreamTransformEntity::getId).collect(Collectors.toList());
        List fieldEntities = this.transformFieldMapper.selectByTransformIds(transformIds);
        Map fieldInfoMap = fieldEntities.stream().map(transformFieldEntity -> {
            StreamField fieldInfo = (StreamField)CommonBeanUtils.copyProperties((Object)transformFieldEntity, StreamField::new);
            fieldInfo.setFieldType(transformFieldEntity.getFieldType());
            fieldInfo.setId(transformFieldEntity.getRankNum());
            return Pair.of((Object)transformFieldEntity.getTransformId(), (Object)fieldInfo);
        }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        List<TransformResponse> transformResponses = entityList.stream().map(entity -> (TransformResponse)CommonBeanUtils.copyProperties((Object)entity, TransformResponse::new)).collect(Collectors.toList());
        transformResponses.forEach(transformResponse -> {
            int transformId = transformResponse.getId();
            List fieldInfos = (List)fieldInfoMap.get(transformId);
            if (CollectionUtils.isNotEmpty((Collection)fieldInfos)) {
                transformResponse.setFieldList(fieldInfos);
            }
        });
        return transformResponses;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean update(TransformRequest request, String operator) {
        LOGGER.info("begin to update transform info: {}", (Object)request);
        this.checkParams(request);
        String groupId = request.getInlongGroupId();
        this.groupCheckService.checkGroupStatus(groupId, operator);
        Preconditions.checkNotNull((Object)request.getId(), (String)ErrorCodeEnum.ID_IS_EMPTY.getMessage());
        StreamTransformEntity exist = this.transformMapper.selectById(request.getId());
        if (exist == null) {
            LOGGER.error("transform not found by id={}", (Object)request.getId());
            throw new BusinessException(ErrorCodeEnum.TRANSFORM_NOT_FOUND);
        }
        String msg = String.format("transform has already updated with groupId=%s, streamId=%s, name=%s, curVersion=%s", request.getInlongGroupId(), request.getInlongStreamId(), request.getTransformName(), request.getVersion());
        if (!exist.getVersion().equals(request.getVersion())) {
            LOGGER.error(msg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        StreamTransformEntity transformEntity = (StreamTransformEntity)CommonBeanUtils.copyProperties((Object)request, StreamTransformEntity::new);
        transformEntity.setModifier(operator);
        int rowCount = this.transformMapper.updateByIdSelective(transformEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(msg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateFieldOpt(transformEntity, request.getFieldList());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean delete(DeleteTransformRequest request, String operator) {
        LOGGER.info("begin to logic delete transform for request={}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"delete request of transform cannot be null");
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        this.groupCheckService.checkGroupStatus(groupId, operator);
        List entityList = this.transformMapper.selectByRelatedId(groupId, streamId, request.getTransformName());
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (StreamTransformEntity entity : entityList) {
                Integer id = entity.getId();
                entity.setIsDeleted(id);
                entity.setModifier(operator);
                int rowCount = this.transformMapper.updateByIdSelective(entity);
                if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                    LOGGER.error("transform has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getTransformName(), entity.getVersion()});
                    throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
                }
                this.transformFieldMapper.deleteAll(id);
            }
        }
        LOGGER.info("success to logic delete transform for request={} by user={}", (Object)request, (Object)operator);
        return true;
    }

    private void checkParams(TransformRequest request) {
        Preconditions.checkNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String groupId = request.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        String transformType = request.getTransformType();
        Preconditions.checkNotNull((Object)transformType, (String)ErrorCodeEnum.TRANSFORM_TYPE_IS_NULL.getMessage());
        String transformName = request.getTransformName();
        Preconditions.checkNotNull((Object)transformName, (String)ErrorCodeEnum.TRANSFORM_NAME_IS_NULL.getMessage());
    }

    private void updateFieldOpt(StreamTransformEntity entity, List<StreamField> fieldList) {
        Integer transformId = entity.getId();
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        this.transformFieldMapper.deleteAll(transformId);
        this.saveFieldOpt(entity, fieldList);
        LOGGER.info("success to update transform field");
    }

    private void saveFieldOpt(StreamTransformEntity entity, List<StreamField> fieldList) {
        LOGGER.info("begin to save transform field={}", fieldList);
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        int size = fieldList.size();
        ArrayList<StreamTransformFieldEntity> entityList = new ArrayList<StreamTransformFieldEntity>(size);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        String transformType = entity.getTransformType();
        Integer transformId = entity.getId();
        for (StreamField fieldInfo : fieldList) {
            StreamTransformFieldEntity fieldEntity = (StreamTransformFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamTransformFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setId(null);
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setFieldType(fieldInfo.getFieldType());
            fieldEntity.setRankNum(fieldInfo.getId());
            fieldEntity.setTransformId(transformId);
            fieldEntity.setTransformType(transformType);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.transformFieldMapper.insertAll(entityList);
        LOGGER.info("success to save transform fields");
    }
}

