/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.user;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.DateUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.util.RSAUtils;
import org.apache.inlong.manager.common.util.SHAUtils;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.dao.mapper.UserEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserRequest;
import org.apache.inlong.manager.service.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final Integer SECRET_KEY_SIZE = 16;
    @Autowired
    private UserEntityMapper userMapper;

    @Override
    public Integer save(UserRequest request, String currentUser) {
        String username = request.getName();
        UserEntity userExists = this.userMapper.selectByName(username);
        String password = request.getPassword();
        Preconditions.checkNull((Object)userExists, (String)("username [" + username + "] already exists"));
        Preconditions.checkTrue((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"password cannot be blank");
        UserEntity entity = new UserEntity();
        entity.setName(username);
        entity.setPassword(SHAUtils.encrypt((String)password));
        entity.setAccountType(request.getAccountType());
        entity.setDueDate(DateUtils.getExpirationDate((Integer)request.getValidDays()));
        entity.setCreator(currentUser);
        entity.setModifier(currentUser);
        entity.setExtParams(request.getExtParams());
        try {
            Map keyPairs = RSAUtils.generateRSAKeyPairs();
            String publicKey = (String)keyPairs.get("RSAPublicKey");
            String privateKey = (String)keyPairs.get("RSAPrivateKey");
            String secretKey = RandomStringUtils.randomAlphanumeric((int)SECRET_KEY_SIZE);
            Integer encryptVersion = AESUtils.getCurrentVersion(null);
            entity.setEncryptVersion(encryptVersion);
            entity.setPublicKey(AESUtils.encryptToString((byte[])publicKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
            entity.setPrivateKey(AESUtils.encryptToString((byte[])privateKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
            entity.setSecretKey(AESUtils.encryptToString((byte[])secretKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
        }
        catch (Exception e) {
            String errMsg = String.format("generate rsa key error: %s", e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
        Preconditions.checkTrue((this.userMapper.insert(entity) > 0 ? 1 : 0) != 0, (String)"Create user failed");
        LOGGER.debug("success to create user info={}", (Object)request);
        return entity.getId();
    }

    @Override
    public UserInfo getById(Integer userId, String currentUser) {
        Preconditions.checkNotNull((Object)userId, (String)"User id cannot be null");
        UserEntity entity = this.userMapper.selectById(userId);
        Preconditions.checkNotNull((Object)entity, (String)("User not exists with id " + userId));
        UserEntity curUser = this.userMapper.selectByName(currentUser);
        Preconditions.checkTrue((Objects.equals(UserTypeEnum.ADMIN.getCode(), curUser.getAccountType()) || Objects.equals(entity.getName(), currentUser) ? 1 : 0) != 0, (String)"Current user does not have permission to get other users' info");
        UserInfo result = new UserInfo();
        result.setId(entity.getId());
        result.setName(entity.getName());
        result.setValidDays(DateUtils.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        result.setAccountType(entity.getAccountType());
        result.setVersion(entity.getVersion());
        if (StringUtils.isNotBlank((CharSequence)entity.getSecretKey()) && StringUtils.isNotBlank((CharSequence)entity.getPublicKey())) {
            try {
                Integer version = entity.getEncryptVersion();
                byte[] secretKeyBytes = AESUtils.decryptAsString((String)entity.getSecretKey(), (Integer)version);
                byte[] publicKeyBytes = AESUtils.decryptAsString((String)entity.getPublicKey(), (Integer)version);
                result.setSecretKey(new String(secretKeyBytes, StandardCharsets.UTF_8));
                result.setPublicKey(new String(publicKeyBytes, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                String errMsg = String.format("decryption error: %s", e.getMessage());
                LOGGER.error(errMsg, (Throwable)e);
                throw new BusinessException(errMsg);
            }
        }
        LOGGER.debug("success to get user info by id={}", (Object)userId);
        return result;
    }

    @Override
    public UserInfo getByName(String name) {
        Preconditions.checkNotNull((Object)name, (String)"User name cannot be null");
        UserEntity entity = this.userMapper.selectByName(name);
        if (entity == null) {
            return null;
        }
        UserInfo userInfo = (UserInfo)CommonBeanUtils.copyProperties((Object)entity, UserInfo::new);
        userInfo.setValidDays(DateUtils.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        return userInfo;
    }

    @Override
    public PageResult<UserInfo> list(UserRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.userMapper.selectByCondition(request);
        List userList = CommonBeanUtils.copyListProperties((List)entityPage, UserInfo::new);
        userList.forEach(entity -> entity.setStatus(entity.getDueDate().after(new Date()) ? "valid" : "invalid"));
        PageResult pageResult = new PageResult(userList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        LOGGER.debug("success to list users for request={}, result size={}", (Object)request, (Object)pageResult.getTotal());
        return pageResult;
    }

    @Override
    public Integer update(UserRequest request, String currentUser) {
        LOGGER.debug("begin to update user info={} by {}", (Object)request, (Object)currentUser);
        Preconditions.checkNotNull((Object)request, (String)"Userinfo cannot be null");
        Preconditions.checkNotNull((Object)request.getId(), (String)"User id cannot be null");
        UserEntity currentUserEntity = this.userMapper.selectByName(currentUser);
        String updateName = request.getName();
        boolean isAdmin = Objects.equals(UserTypeEnum.ADMIN.getCode(), currentUserEntity.getAccountType());
        Preconditions.checkTrue((isAdmin || Objects.equals(updateName, currentUser) ? 1 : 0) != 0, (String)"You are not a manager and do not have permission to update other users");
        boolean managerToOrdinary = isAdmin && Objects.equals(UserTypeEnum.OPERATOR.getCode(), request.getAccountType()) && Objects.equals(currentUser, updateName);
        Preconditions.checkFalse((boolean)managerToOrdinary, (String)"You are a manager and you cannot change to an ordinary user");
        UserEntity updateUserEntity = this.userMapper.selectById(request.getId());
        Preconditions.checkNotNull((Object)updateUserEntity, (String)("User not exists with id=" + request.getId()));
        String errMsg = String.format("user has already updated with username=%s, curVersion=%s", updateName, request.getVersion());
        if (!Objects.equals(updateUserEntity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        UserEntity targetUserEntity = this.userMapper.selectByName(updateName);
        Preconditions.checkTrue((Objects.isNull(targetUserEntity) || Objects.equals(targetUserEntity.getName(), updateUserEntity.getName()) ? 1 : 0) != 0, (String)("Username [" + updateName + "] already exists"));
        if (!isAdmin) {
            String oldPassword = request.getPassword();
            String oldPasswordHash = SHAUtils.encrypt((String)oldPassword);
            Preconditions.checkTrue((boolean)oldPasswordHash.equals(updateUserEntity.getPassword()), (String)"Old password is wrong");
            Integer validDays = DateUtils.getValidDays((Date)updateUserEntity.getCreateTime(), (Date)updateUserEntity.getDueDate());
            Preconditions.checkTrue((request.getValidDays() <= validDays ? 1 : 0) != 0, (String)"Ordinary users are not allowed to add valid days");
            Preconditions.checkTrue((boolean)Objects.equals(updateUserEntity.getAccountType(), request.getAccountType()), (String)"Ordinary users are not allowed to update account type");
        }
        if (!StringUtils.isBlank((CharSequence)request.getNewPassword())) {
            String newPasswordHash = SHAUtils.encrypt((String)request.getNewPassword());
            updateUserEntity.setPassword(newPasswordHash);
        }
        updateUserEntity.setDueDate(DateUtils.getExpirationDate((Integer)request.getValidDays()));
        updateUserEntity.setAccountType(request.getAccountType());
        updateUserEntity.setName(updateName);
        updateUserEntity.setExtParams(request.getExtParams());
        int rowCount = this.userMapper.updateByPrimaryKeySelective(updateUserEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("success to update user info={} by {}", (Object)request, (Object)currentUser);
        return updateUserEntity.getId();
    }

    @Override
    public Boolean delete(Integer userId, String currentUser) {
        Preconditions.checkNotNull((Object)userId, (String)"User id should not be empty");
        UserEntity curUser = this.userMapper.selectByName(currentUser);
        UserEntity entity = this.userMapper.selectById(userId);
        Preconditions.checkTrue((boolean)curUser.getAccountType().equals(UserTypeEnum.ADMIN.getCode()), (String)"Current user is not a manager and does not have permission to delete users");
        Preconditions.checkTrue((!Objects.equals(entity.getName(), currentUser) ? 1 : 0) != 0, (String)"Current user does not have permission to delete himself");
        this.userMapper.deleteById(userId);
        LOGGER.debug("success to delete user by id={}, current user={}", (Object)userId, (Object)currentUser);
        return true;
    }
}

