/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.HttpUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.tubemq.TubeClusterDTO;
import org.apache.inlong.manager.pojo.cluster.tubemq.TubeClusterInfo;
import org.apache.inlong.manager.pojo.cluster.tubemq.TubeClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.apache.inlong.manager.service.group.InlongGroupOperator4NoneMQ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TubeClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupOperator4NoneMQ.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "TUBEMQ";
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        TubeClusterRequest tubeRequest = (TubeClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)tubeRequest, (Object)targetEntity, (boolean)true);
        try {
            TubeClusterDTO dto = (TubeClusterDTO)this.objectMapper.convertValue((Object)tubeRequest, TubeClusterDTO.class);
            dto.setMasterIpPortList(request.getUrl());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.info("success to set entity for tubemq cluster");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        TubeClusterInfo tubeClusterInfo = new TubeClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)tubeClusterInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            TubeClusterDTO dto = TubeClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)tubeClusterInfo);
        }
        LOGGER.info("success to get tubemq cluster info from entity");
        return tubeClusterInfo;
    }

    @Override
    public Boolean testConnection(ClusterRequest request) {
        String masterUrl = request.getUrl();
        int hostBeginIndex = masterUrl.lastIndexOf("/");
        int portBeginIndex = masterUrl.lastIndexOf(":");
        String host = masterUrl.substring(hostBeginIndex + 1, portBeginIndex);
        int port = Integer.parseInt(masterUrl.substring(portBeginIndex + 1));
        Preconditions.checkNotNull((Object)masterUrl, (String)"connection url cannot be empty");
        try {
            boolean result = HttpUtils.checkConnectivity((String)host, (int)port, (int)10, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("tube connection not null - connection success for masterUrl={}", (Object)masterUrl);
            return result;
        }
        catch (Exception e) {
            String errMsg = String.format("tube connection failed for masterUrl=%s", masterUrl);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

