/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.consume;

import org.apache.inlong.manager.common.enums.ConsumeStatus;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumeProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.consume.InlongConsumeService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongConsumeProcessService {
    private static final Logger log = LoggerFactory.getLogger(InlongConsumeProcessService.class);
    @Autowired
    private InlongConsumeService consumeService;
    @Autowired
    private WorkflowService workflowService;

    public WorkflowResult startProcess(Integer id, String operator) {
        this.consumeService.updateStatus(id, ConsumeStatus.TO_BE_APPROVAL.getCode(), operator);
        return this.workflowService.start(ProcessName.APPLY_CONSUME_PROCESS, operator, (ProcessForm)this.genApplyConsumeProcessForm(id));
    }

    private ApplyConsumeProcessForm genApplyConsumeProcessForm(Integer id) {
        ApplyConsumeProcessForm form = new ApplyConsumeProcessForm();
        form.setConsumeInfo(this.consumeService.get(id));
        return form;
    }
}

