/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateGroupCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateGroupCompleteListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private StreamSourceService sourceService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        GroupOperateType operateType = form.getGroupOperateType();
        log.info("begin to execute UpdateGroupCompleteListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        InlongGroupInfo groupInfo = form.getGroupInfo();
        InlongGroupRequest groupRequest = groupInfo.genRequest();
        String operator = context.getOperator();
        switch (operateType) {
            case SUSPEND: {
                this.groupService.updateStatus(groupId, GroupStatus.SUSPENDED.getCode(), operator);
                this.groupService.update(groupRequest, operator);
                break;
            }
            case RESTART: {
                this.groupService.updateStatus(groupId, GroupStatus.RESTARTED.getCode(), operator);
                this.groupService.update(groupRequest, operator);
                break;
            }
            case DELETE: {
                this.groupService.delete(groupId, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
        if (InlongConstants.LIGHTWEIGHT_MODE.equals(groupInfo.getLightweight())) {
            this.changeSource4Lightweight(groupId, operateType, operator);
        }
        log.info("success to execute UpdateGroupCompleteListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        return ListenerResult.success();
    }

    private void changeSource4Lightweight(String groupId, GroupOperateType operateType, String operator) {
        switch (operateType) {
            case SUSPEND: {
                this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_FROZEN.getCode(), operator);
                break;
            }
            case RESTART: {
                this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_NORMAL.getCode(), operator);
                break;
            }
            case DELETE: {
                this.sourceService.logicDeleteAll(groupId, null, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
    }
}

