/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.sort;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperator;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamSortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamSortConfigListener.class);
    @Autowired
    private SortConfigOperatorFactory operatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String className = processForm.getClass().getSimpleName();
        String groupId = processForm.getInlongGroupId();
        if (processForm instanceof StreamResourceProcessForm) {
            LOGGER.info("accept sort config listener as the process is {} for groupId [{}]", (Object)className, (Object)groupId);
            return true;
        }
        LOGGER.info("not accept sort config listener as the process is {} for groupId [{}]", (Object)className, (Object)groupId);
        return false;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        LOGGER.info("begin to build sort config for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        GroupOperateType operateType = form.getGroupOperateType();
        if (operateType == GroupOperateType.SUSPEND || operateType == GroupOperateType.DELETE) {
            LOGGER.info("not build sort config for groupId={}, streamId={}, as the group operate type={}", new Object[]{groupId, streamId, operateType});
            return ListenerResult.success();
        }
        InlongGroupInfo groupInfo = form.getGroupInfo();
        List streamSinks = streamInfo.getSinkList();
        if (CollectionUtils.isEmpty((Collection)streamSinks)) {
            LOGGER.warn("not build sort config for groupId={}, streamId={}, as not found any sinks", (Object)groupId, (Object)streamId);
            return ListenerResult.success();
        }
        List<InlongStreamInfo> streamInfos = Collections.singletonList(streamInfo);
        try {
            SortConfigOperator operator = this.operatorFactory.getInstance(groupInfo.getEnableZookeeper());
            operator.buildConfig(groupInfo, streamInfos, true);
        }
        catch (Exception e) {
            String msg = String.format("failed to build sort config for groupId=%s, streamId=%s, ", groupId, streamId);
            LOGGER.error(msg + "streamInfos=" + streamInfos, (Throwable)e);
            throw new WorkflowListenerException(msg + e.getMessage());
        }
        LOGGER.info("success to build sort config for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return ListenerResult.success();
    }
}

