/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.starrocks;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.starrocks.StarRocksDataNodeDTO;
import org.apache.inlong.manager.pojo.node.starrocks.StarRocksDataNodeInfo;
import org.apache.inlong.manager.pojo.node.starrocks.StarRocksDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.starrocks.StarRocksJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StarRocksDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarRocksDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "STARROCKS";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        StarRocksDataNodeInfo starRocksDataNodeInfo = new StarRocksDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)starRocksDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            StarRocksDataNodeDTO dto = StarRocksDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)starRocksDataNodeInfo);
        }
        return starRocksDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        StarRocksDataNodeRequest starRocksDataNodeRequest = (StarRocksDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)starRocksDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            StarRocksDataNodeDTO dto = StarRocksDataNodeDTO.getFromRequest((StarRocksDataNodeRequest)starRocksDataNodeRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for StarRocks node: %s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean testConnection(DataNodeRequest request) {
        String jdbcUrl = request.getUrl();
        String username = request.getUsername();
        String password = request.getToken();
        Preconditions.checkNotNull((Object)jdbcUrl, (String)"connection jdbcUrl cannot be empty");
        try (Connection ignored = StarRocksJdbcUtils.getConnection(jdbcUrl, username, password);){
            LOGGER.info("starRocks connection not null - connection success for jdbcUrl={}, username={}, password={}", new Object[]{jdbcUrl, username, password});
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("starRocks connection failed for jdbcUrl=%s, username=%s, password=%s", jdbcUrl, username, password);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

