/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.common.plugin.PluginDefinition;
import org.apache.inlong.manager.service.plugin.PluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0x7FFFFFFF)
public class PluginService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PluginService.class);
    public static final String DEFAULT_PLUGIN_LOCATION = "plugins";
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    @Value(value="${plugin.location?:}")
    private String pluginLocation;
    @Autowired
    private List<PluginBinder> pluginBinders;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.pluginLocation)) {
            this.pluginLocation = DEFAULT_PLUGIN_LOCATION;
        }
        log.info("plugin location is {}", (Object)this.pluginLocation);
        this.pluginReload();
    }

    public void pluginReload() {
        Path path = Paths.get(this.pluginLocation, new String[0]).toAbsolutePath();
        log.info("search for plugin in {}", (Object)path);
        if (!path.toFile().exists()) {
            log.warn("plugin directory not found");
            return;
        }
        PluginClassLoader pluginLoader = PluginClassLoader.getFromPluginUrl(path.toString(), Thread.currentThread().getContextClassLoader());
        Map<String, PluginDefinition> pluginDefinitions = pluginLoader.getPluginDefinitions();
        if (MapUtils.isEmpty(pluginDefinitions)) {
            log.warn("plugin definition not found in {}", (Object)this.pluginLocation);
            return;
        }
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (PluginDefinition pluginDefinition : pluginDefinitions.values()) {
            List classNames = pluginDefinition.getPluginClasses();
            for (String name : classNames) {
                try {
                    Class<?> pluginClass = pluginLoader.loadClass(name);
                    Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    plugins.add((Plugin)plugin);
                }
                catch (Throwable e) {
                    log.error("create plugin instance error: ", e);
                    throw new BusinessException("create plugin instance error: " + e.getMessage());
                }
            }
        }
        this.plugins.addAll(plugins);
        for (PluginBinder binder : this.pluginBinders) {
            for (Plugin plugin : plugins) {
                binder.acceptPlugin(plugin);
                log.info("plugin {} loaded by plugin binder {}", plugin.getClass(), binder.getClass());
            }
        }
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPluginLocation(String pluginLocation) {
        this.pluginLocation = pluginLocation;
    }

    public String getPluginLocation() {
        return this.pluginLocation;
    }

    public List<PluginBinder> getPluginBinders() {
        return this.pluginBinders;
    }
}

