/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue.pulsar;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarUtils {
    private static final Logger log = LoggerFactory.getLogger(PulsarUtils.class);

    private PulsarUtils() {
    }

    public static PulsarAdmin getPulsarAdmin(PulsarClusterInfo pulsarCluster) throws PulsarClientException {
        Preconditions.checkNotNull((Object)pulsarCluster.getAdminUrl(), (String)"Pulsar adminUrl cannot be empty");
        PulsarAdmin pulsarAdmin = StringUtils.isEmpty((CharSequence)pulsarCluster.getToken()) ? PulsarUtils.getPulsarAdmin(pulsarCluster.getAdminUrl()) : PulsarUtils.getPulsarAdmin(pulsarCluster.getAdminUrl(), pulsarCluster.getToken());
        return pulsarAdmin;
    }

    public static PulsarAdmin getPulsarAdmin(String serviceHttpUrl) throws PulsarClientException {
        return PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).build();
    }

    private static PulsarAdmin getPulsarAdmin(String serviceHttpUrl, String token) throws PulsarClientException {
        return PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).authentication(AuthenticationFactory.token((String)token)).build();
    }

    public static List<String> getPulsarClusters(PulsarAdmin pulsarAdmin) throws PulsarAdminException {
        return pulsarAdmin.clusters().getClusters();
    }

    public static String getServiceUrl(PulsarAdmin pulsarAdmin, String pulsarCluster) throws PulsarAdminException {
        return pulsarAdmin.clusters().getCluster(pulsarCluster).getServiceUrl();
    }
}

