/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.node.hive.HiveDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.hive.HiveColumnInfo;
import org.apache.inlong.manager.pojo.sink.hive.HiveSinkDTO;
import org.apache.inlong.manager.pojo.sink.hive.HiveTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.hive.HiveJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HiveResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "HIVE".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private HiveSinkDTO getHiveInfo(SinkInfo sinkInfo) {
        HiveSinkDTO hiveInfo = HiveSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        if (StringUtils.isBlank((CharSequence)hiveInfo.getJdbcUrl())) {
            String dataNodeName = sinkInfo.getDataNodeName();
            Preconditions.checkNotEmpty((String)dataNodeName, (String)"hive jdbc url not specified and data node is empty");
            HiveDataNodeInfo dataNodeInfo = (HiveDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)hiveInfo);
            hiveInfo.setJdbcUrl(dataNodeInfo.getUrl());
            hiveInfo.setPassword(dataNodeInfo.getToken());
        }
        return hiveInfo;
    }

    private void createTable(SinkInfo sinkInfo) {
        LOGGER.info("begin to create hive table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOGGER.warn("no hive fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList<HiveColumnInfo> columnList = new ArrayList<HiveColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            HiveColumnInfo columnInfo = new HiveColumnInfo();
            columnInfo.setName(field.getFieldName());
            columnInfo.setType(field.getFieldType());
            columnInfo.setDesc(field.getFieldComment());
            columnList.add(columnInfo);
        }
        try {
            HiveSinkDTO hiveInfo = this.getHiveInfo(sinkInfo);
            HiveTableInfo tableInfo = HiveSinkDTO.getHiveTableInfo((HiveSinkDTO)hiveInfo, columnList);
            String url = hiveInfo.getJdbcUrl();
            String user = hiveInfo.getUsername();
            String password = hiveInfo.getPassword();
            String dbName = tableInfo.getDbName();
            String tableName = tableInfo.getTableName();
            HiveJdbcUtils.createDb(url, user, password, dbName);
            List<String> tables = HiveJdbcUtils.getTables(url, user, password, dbName);
            boolean tableExists = tables.contains(tableName);
            if (!tableExists) {
                HiveJdbcUtils.createTable(url, user, password, tableInfo);
            } else {
                List<HiveColumnInfo> existColumns = HiveJdbcUtils.getColumns(url, user, password, dbName, tableName);
                List<HiveColumnInfo> needAddColumns = tableInfo.getColumns().stream().skip(existColumns.size()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    HiveJdbcUtils.addColumns(url, user, password, dbName, tableName, needAddColumns);
                }
            }
            String info = "success to create hive resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create hive table failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }
}

