/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hudi;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.node.hudi.HudiDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.hudi.HudiColumnInfo;
import org.apache.inlong.manager.pojo.sink.hudi.HudiSinkDTO;
import org.apache.inlong.manager.pojo.sink.hudi.HudiTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiCatalogClient;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HudiResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HudiResourceOperator.class);
    private static final String CATALOG_TYPE_HIVE = "HIVE";
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "HUDI".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTableIfAbsent(sinkInfo);
    }

    private HudiSinkDTO getHudiInfo(SinkInfo sinkInfo) {
        HudiSinkDTO hudiInfo = HudiSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        if (StringUtils.isBlank((CharSequence)hudiInfo.getCatalogUri()) && CATALOG_TYPE_HIVE.equals(hudiInfo.getCatalogType())) {
            String dataNodeName = sinkInfo.getDataNodeName();
            Preconditions.checkNotEmpty((String)dataNodeName, (String)"Hudi catalog uri not specified and data node is empty");
            HudiDataNodeInfo dataNodeInfo = (HudiDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)hudiInfo);
            hudiInfo.setCatalogUri(dataNodeInfo.getUrl());
        }
        hudiInfo.setDataPath(hudiInfo.getWarehouse() + "/" + hudiInfo.getDbName() + ".db/" + hudiInfo.getTableName());
        return hudiInfo;
    }

    private void createTableIfAbsent(SinkInfo sinkInfo) {
        LOGGER.info("begin to create hudi table for sinkInfo={}", (Object)sinkInfo);
        HudiSinkDTO hudiInfo = this.getHudiInfo(sinkInfo);
        List<HudiColumnInfo> columnInfoList = this.getColumnList(sinkInfo);
        if (CollectionUtils.isEmpty(columnInfoList)) {
            throw new IllegalArgumentException("no hudi columns specified");
        }
        HudiTableInfo tableInfo = HudiSinkDTO.getHudiTableInfo((HudiSinkDTO)hudiInfo, columnInfoList);
        String metastoreUri = hudiInfo.getCatalogUri();
        String warehouse = hudiInfo.getWarehouse();
        String dbName = hudiInfo.getDbName();
        String tableName = hudiInfo.getTableName();
        try (HudiCatalogClient client = null;){
            client = new HudiCatalogClient(metastoreUri, warehouse, dbName);
            client.open();
            client.createDatabase(warehouse, true);
            boolean tableExists = client.tableExist(tableName);
            if (!tableExists) {
                client.createTable(tableName, tableInfo, true);
            } else {
                List<HudiColumnInfo> existColumns = client.getColumns(dbName, tableName);
                List<HudiColumnInfo> needAddColumns = tableInfo.getColumns().stream().skip(existColumns.size()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    client.addColumns(tableName, needAddColumns);
                    LOGGER.info("{} columns added for table {}", (Object)needAddColumns.size(), (Object)tableName);
                }
            }
            String info = "success to create Hudi resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo = {}", (Object)info);
        }
    }

    private List<HudiColumnInfo> getColumnList(SinkInfo sinkInfo) {
        List fieldList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        ArrayList<HudiColumnInfo> columnList = new ArrayList<HudiColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            HudiColumnInfo column = HudiColumnInfo.getFromJson((String)field.getExtParams());
            column.setName(field.getFieldName());
            column.setType(field.getFieldType());
            column.setDesc(field.getFieldComment());
            column.setRequired(field.getIsRequired() != null && field.getIsRequired() > 0);
            columnList.add(column);
        }
        return columnList;
    }
}

