/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.starrocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.node.starrocks.StarRocksDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksColumnInfo;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksSinkDTO;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.mysql.MySQLResourceOperator;
import org.apache.inlong.manager.service.resource.sink.starrocks.StarRocksJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StarRocksResourceOperator
implements SinkResourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper fieldEntityMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "STARROCKS".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOG.info("begin to create sink resources sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOG.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOG.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOG.info("begin to create starRocks table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.fieldEntityMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOG.warn("no starRocks fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        List<StarRocksColumnInfo> columnList = this.getStarRocksColumnInfoFromSink(fieldList);
        StarRocksSinkDTO sinkDTO = this.getStarRocksInfo(sinkInfo);
        StarRocksTableInfo tableInfo = StarRocksSinkDTO.getTableInfo((StarRocksSinkDTO)sinkDTO, columnList);
        String url = sinkDTO.getJdbcUrl();
        String username = sinkDTO.getUsername();
        String password = sinkDTO.getPassword();
        String dbName = sinkDTO.getDatabaseName();
        String tableName = sinkDTO.getTableName();
        try {
            StarRocksJdbcUtils.createDb(url, username, password, dbName);
            String dbUrl = url + "/" + dbName;
            StarRocksJdbcUtils.createTable(dbUrl, username, password, tableInfo);
            StarRocksJdbcUtils.addColumns(dbUrl, username, password, dbName, tableName, columnList);
            String info = "success to create StarRocks resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOG.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create StarRocks table failed: " + e.getMessage();
            LOG.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOG.info("success create StarRocks table for data sink [" + sinkInfo.getId() + "]");
    }

    public List<StarRocksColumnInfo> getStarRocksColumnInfoFromSink(List<StreamSinkFieldEntity> sinkList) {
        ArrayList<StarRocksColumnInfo> columnInfoList = new ArrayList<StarRocksColumnInfo>();
        for (StreamSinkFieldEntity fieldEntity : sinkList) {
            StarRocksColumnInfo starRocksColumnInfo;
            if (StringUtils.isNotBlank((CharSequence)fieldEntity.getExtParams())) {
                starRocksColumnInfo = StarRocksColumnInfo.getFromJson((String)fieldEntity.getExtParams());
                CommonBeanUtils.copyProperties((Object)fieldEntity, (Object)starRocksColumnInfo, (boolean)true);
                columnInfoList.add(starRocksColumnInfo);
                continue;
            }
            starRocksColumnInfo = new StarRocksColumnInfo();
            CommonBeanUtils.copyProperties((Object)fieldEntity, (Object)starRocksColumnInfo, (boolean)true);
            columnInfoList.add(starRocksColumnInfo);
        }
        return columnInfoList;
    }

    private StarRocksSinkDTO getStarRocksInfo(SinkInfo sinkInfo) {
        StarRocksSinkDTO starRocksInfo = StarRocksSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        if (StringUtils.isBlank((CharSequence)starRocksInfo.getJdbcUrl())) {
            String dataNodeName = sinkInfo.getDataNodeName();
            Preconditions.checkNotEmpty((String)dataNodeName, (String)"starRocks jdbc url not specified and data node is empty");
            StarRocksDataNodeInfo dataNodeInfo = (StarRocksDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)starRocksInfo);
            starRocksInfo.setJdbcUrl(dataNodeInfo.getUrl());
            starRocksInfo.setPassword(dataNodeInfo.getToken());
        }
        return starRocksInfo;
    }
}

