/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink;

import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.sink.StreamSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSinkOperator
implements StreamSinkOperator {
    protected static final String KEY_GROUP_ID = "inlongGroupId";
    protected static final String KEY_STREAM_ID = "inlongStreamId";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSinkOperator.class);
    @Autowired
    protected StreamSinkEntityMapper sinkMapper;
    @Autowired
    protected StreamSinkFieldEntityMapper sinkFieldMapper;
    @Autowired
    protected DataNodeOperateHelper dataNodeHelper;

    protected abstract void setTargetEntity(SinkRequest var1, StreamSinkEntity var2);

    protected abstract String getSinkType();

    @Override
    public Integer saveOpt(SinkRequest request, String operator) {
        StreamSinkEntity entity = (StreamSinkEntity)CommonBeanUtils.copyProperties((Object)request, StreamSinkEntity::new);
        entity.setStatus(SinkStatus.NEW.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.setTargetEntity(request, entity);
        this.sinkMapper.insert(entity);
        Integer sinkId = entity.getId();
        request.setId(sinkId);
        this.saveFieldOpt(request);
        return sinkId;
    }

    @Override
    public List<SinkField> getSinkFields(Integer sinkId) {
        List sinkFieldEntities = this.sinkFieldMapper.selectBySinkId(sinkId);
        return CommonBeanUtils.copyListProperties((List)sinkFieldEntities, SinkField::new);
    }

    @Override
    public PageResult<? extends StreamSink> getPageInfo(Page<StreamSinkEntity> entityPage) {
        if (CollectionUtils.isEmpty(entityPage)) {
            return PageResult.empty();
        }
        List streamSinks = entityPage.getResult().stream().map(this::getFromEntity).collect(Collectors.toList());
        return new PageResult(streamSinks, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
    }

    @Override
    public void updateOpt(SinkRequest request, SinkStatus nextStatus, String operator) {
        StreamSinkEntity entity = this.sinkMapper.selectByPrimaryKey(request.getId());
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SINK_INFO_NOT_FOUND.getMessage());
        String errMsg = String.format("sink has already updated with groupId=%s, streamId=%s, name=%s, curVersion=%s", request.getInlongGroupId(), request.getInlongStreamId(), request.getSinkName(), request.getVersion());
        if (!Objects.equals(entity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)entity, (boolean)true);
        this.setTargetEntity(request, entity);
        entity.setPreviousStatus(entity.getStatus());
        if (nextStatus != null) {
            entity.setStatus(nextStatus.getCode());
        }
        entity.setModifier(operator);
        int rowCount = this.sinkMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        boolean onlyAdd = SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(entity.getPreviousStatus());
        this.updateFieldOpt(onlyAdd, request);
        LOGGER.info("success to update sink of type={}", (Object)request.getSinkType());
    }

    @Override
    public void updateFieldOpt(Boolean onlyAdd, SinkRequest request) {
        Integer sinkId = request.getId();
        List fieldRequestList = request.getSinkFieldList();
        if (CollectionUtils.isEmpty((Collection)fieldRequestList)) {
            return;
        }
        if (onlyAdd.booleanValue()) {
            List existsFieldList = this.sinkFieldMapper.selectBySinkId(sinkId);
            if (existsFieldList.size() > fieldRequestList.size()) {
                throw new BusinessException(ErrorCodeEnum.SINK_FIELD_UPDATE_NOT_ALLOWED);
            }
            for (int i = 0; i < existsFieldList.size(); ++i) {
                if (((StreamSinkFieldEntity)existsFieldList.get(i)).getFieldName().equals(((SinkField)fieldRequestList.get(i)).getFieldName())) continue;
                throw new BusinessException(ErrorCodeEnum.SINK_FIELD_UPDATE_NOT_ALLOWED);
            }
        }
        this.sinkFieldMapper.deleteAll(sinkId);
        this.saveFieldOpt(request);
        LOGGER.info("success to update sink field");
    }

    @Override
    public void saveFieldOpt(SinkRequest request) {
        List fieldList = request.getSinkFieldList();
        LOGGER.info("begin to save sink fields={}", (Object)fieldList);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return;
        }
        int size = fieldList.size();
        ArrayList<StreamSinkFieldEntity> entityList = new ArrayList<StreamSinkFieldEntity>(size);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sinkType = request.getSinkType();
        Integer sinkId = request.getId();
        for (SinkField fieldInfo : fieldList) {
            this.checkFieldInfo(fieldInfo);
            StreamSinkFieldEntity fieldEntity = (StreamSinkFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamSinkFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setSinkType(sinkType);
            fieldEntity.setSinkId(sinkId);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.sinkFieldMapper.insertAll(entityList);
        LOGGER.info("success to save sink fields");
    }

    @Override
    public void deleteOpt(StreamSinkEntity entity, String operator) {
        entity.setPreviousStatus(entity.getStatus());
        entity.setStatus(InlongConstants.DELETED_STATUS);
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.sinkMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("sink has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getSinkName(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.sinkFieldMapper.logicDeleteAll(entity.getId());
    }

    @Override
    public Map<String, String> parse2IdParams(StreamSinkEntity streamSink, List<String> fields) {
        try {
            Map param = (Map)JsonUtils.parseObject((String)streamSink.getExtParams(), HashMap.class);
            assert (param != null);
            param.put(KEY_GROUP_ID, streamSink.getInlongGroupId());
            param.put(KEY_STREAM_ID, streamSink.getInlongStreamId());
            return param;
        }
        catch (Exception e) {
            LOGGER.error(String.format("cannot parse properties for groupId=%s, streamId=%s, sinkName=%s, the row properties: %s", streamSink.getInlongGroupId(), streamSink.getInlongStreamId(), streamSink.getSinkName(), streamSink.getExtParams()), (Throwable)e);
            return null;
        }
    }

    protected void checkFieldInfo(SinkField fieldInfo) {
    }
}

