/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.mqtt.MqttSource;
import org.apache.inlong.manager.pojo.source.mqtt.MqttSourceDTO;
import org.apache.inlong.manager.pojo.source.mqtt.MqttSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqttSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "MQTT".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "MQTT";
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        MqttSourceRequest sourceRequest = (MqttSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            MqttSourceDTO dto = MqttSourceDTO.getFromRequest((MqttSourceRequest)sourceRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        MqttSource source = new MqttSource();
        if (entity == null) {
            return source;
        }
        MqttSourceDTO dto = MqttSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> streamFields = super.getSourceFields(entity.getId());
        source.setFieldList(streamFields);
        return source;
    }
}

