/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.stream;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamFieldEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamFieldEntityMapper;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.sink.SinkBriefInfo;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamApproveRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtParam;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamPageRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InlongStreamServiceImpl
implements InlongStreamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongStreamServiceImpl.class);
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private InlongStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    private InlongStreamExtEntityMapper streamExtMapper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private StreamSourceService sourceService;
    @Autowired
    private StreamSinkService sinkService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to save inlong stream info={}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"inlong stream info is empty");
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, streamId);
        if (count >= 1) {
            LOGGER.error("inlong stream id [{}] has already exists", (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE);
        }
        if (StringUtils.isEmpty((CharSequence)request.getMqResource())) {
            request.setMqResource(streamId);
        }
        InlongStreamEntity streamEntity = (InlongStreamEntity)CommonBeanUtils.copyProperties((Object)request, InlongStreamEntity::new);
        streamEntity.setStatus(StreamStatus.NEW.getCode());
        streamEntity.setCreator(operator);
        streamEntity.setModifier(operator);
        String extParam = InlongStreamExtParam.packExtParams((InlongStreamRequest)request);
        streamEntity.setExtParams(extParam);
        this.streamMapper.insertSelective(streamEntity);
        this.saveField(groupId, streamId, request.getFieldList());
        List extList = request.getExtList();
        if (CollectionUtils.isNotEmpty((Collection)extList)) {
            this.saveOrUpdateExt(groupId, streamId, extList);
        }
        LOGGER.info("success to save inlong stream info for groupId={}", (Object)groupId);
        return streamEntity.getId();
    }

    @Override
    public Integer save(InlongStreamRequest request, UserInfo opInfo) {
        List<String> inCharges;
        if (request == null) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "inlong stream info is empty");
        }
        if (opInfo == null) {
            throw new BusinessException(ErrorCodeEnum.LOGIN_USER_EMPTY);
        }
        String groupId = request.getInlongGroupId();
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        }
        String streamId = request.getInlongStreamId();
        if (StringUtils.isBlank((CharSequence)streamId)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        }
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        if (!opInfo.getRoles().contains(UserTypeEnum.ADMIN.name()) && !(inCharges = Arrays.asList(entity.getInCharges().split(","))).contains(opInfo.getName())) {
            throw new BusinessException(ErrorCodeEnum.GROUP_PERMISSION_DENIED);
        }
        GroupStatus curState = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.isTempStatus((GroupStatus)curState)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED, String.format("inlong groupId=%s status=%s was not allowed to add/update/delete stream", groupId, curState));
        }
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, streamId);
        if (count >= 1) {
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE);
        }
        if (StringUtils.isEmpty((CharSequence)request.getMqResource())) {
            request.setMqResource(streamId);
        }
        String extParams = InlongStreamExtParam.packExtParams((InlongStreamRequest)request);
        request.setExtParams(extParams);
        InlongStreamEntity streamEntity = (InlongStreamEntity)CommonBeanUtils.copyProperties((Object)request, InlongStreamEntity::new);
        streamEntity.setStatus(StreamStatus.NEW.getCode());
        streamEntity.setCreator(opInfo.getName());
        streamEntity.setModifier(opInfo.getName());
        this.streamMapper.insertSelective(streamEntity);
        this.saveField(groupId, streamId, request.getFieldList());
        List extList = request.getExtList();
        if (CollectionUtils.isNotEmpty((Collection)extList)) {
            this.saveOrUpdateExt(groupId, streamId, extList);
        }
        return streamEntity.getId();
    }

    @Override
    public Boolean exist(String groupId, String streamId) {
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        return streamEntity != null;
    }

    @Override
    public InlongStreamInfo get(String groupId, String streamId) {
        LOGGER.debug("begin to get inlong stream by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        InlongStreamInfo streamInfo = (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamInfo::new);
        List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
        streamInfo.setFieldList(streamFields);
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
        List exts = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
        streamInfo.setExtList(exts);
        InlongStreamExtParam.unpackExtParams((String)streamEntity.getExtParams(), (Object)streamInfo);
        List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
        streamInfo.setSinkList(sinkList);
        List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
        streamInfo.setSourceList(sourceList);
        LOGGER.info("success to get inlong stream for groupId={}", (Object)groupId);
        return streamInfo;
    }

    @Override
    public InlongStreamInfo get(String groupId, String streamId, UserInfo opInfo) {
        List<String> inCharges;
        if (opInfo == null) {
            throw new BusinessException(ErrorCodeEnum.LOGIN_USER_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)streamId)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        }
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        if (!opInfo.getRoles().contains(UserTypeEnum.ADMIN.name()) && !(inCharges = Arrays.asList(entity.getInCharges().split(","))).contains(opInfo.getName())) {
            throw new BusinessException(ErrorCodeEnum.GROUP_PERMISSION_DENIED);
        }
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        InlongStreamInfo streamInfo = (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamInfo::new);
        InlongStreamExtParam.unpackExtParams((String)streamEntity.getExtParams(), (Object)streamInfo);
        List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
        streamInfo.setFieldList(streamFields);
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
        List exts = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
        streamInfo.setExtList(exts);
        List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
        streamInfo.setSinkList(sinkList);
        List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
        streamInfo.setSourceList(sourceList);
        return streamInfo;
    }

    @Override
    public List<InlongStreamInfo> list(String groupId) {
        LOGGER.debug("begin to list inlong streams by groupId={}", (Object)groupId);
        List inlongStreamEntityList = this.streamMapper.selectByGroupId(groupId);
        List streamList = CommonBeanUtils.copyListProperties((List)inlongStreamEntityList, InlongStreamInfo::new);
        List<StreamField> streamFields = this.getStreamFields(groupId, null);
        Map streamFieldMap = streamFields.stream().collect(Collectors.groupingBy(StreamField::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, null);
        Map extInfoMap = extEntities.stream().map(extEntity -> (InlongStreamExtInfo)CommonBeanUtils.copyProperties((Object)extEntity, InlongStreamExtInfo::new)).collect(Collectors.groupingBy(InlongStreamExtInfo::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        streamList.forEach(streamInfo -> {
            String streamId = streamInfo.getInlongStreamId();
            InlongStreamExtParam.unpackExtParams((String)streamInfo.getExtParams(), (Object)streamInfo);
            List fieldInfos = (List)streamFieldMap.get(streamId);
            streamInfo.setFieldList(fieldInfos);
            List extInfos = (List)extInfoMap.get(streamId);
            streamInfo.setExtList(extInfos);
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            streamInfo.setSinkList(sinkList);
            List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
            streamInfo.setSourceList(sourceList);
        });
        return streamList;
    }

    private List<StreamField> getStreamFields(String groupId, String streamId) {
        List fieldEntityList = this.streamFieldMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isEmpty((Collection)fieldEntityList)) {
            return Collections.emptyList();
        }
        return CommonBeanUtils.copyListProperties((List)fieldEntityList, StreamField::new);
    }

    @Override
    public PageResult<InlongStreamBriefInfo> listBrief(InlongStreamPageRequest request) {
        LOGGER.debug("begin to list inlong stream page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page entityPage = (Page)this.streamMapper.selectByCondition(request);
        List streamList = CommonBeanUtils.copyListProperties((List)entityPage, InlongStreamBriefInfo::new);
        PageResult pageResult = new PageResult(streamList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        LOGGER.debug("success to list inlong stream info for groupId={}", (Object)request.getInlongGroupId());
        return pageResult;
    }

    @Override
    public List<InlongStreamBriefInfo> listBrief(InlongStreamPageRequest request, UserInfo opInfo) {
        if (request == null) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "group query request cannot be empty");
        }
        if (opInfo == null) {
            throw new BusinessException(ErrorCodeEnum.LOGIN_USER_EMPTY);
        }
        request.setCurrentUser(LoginUserUtils.getLoginUser().getName());
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.getLoginUser().getRoles().contains("ADMIN")));
        return CommonBeanUtils.copyListProperties((List)this.streamMapper.selectByCondition(request), InlongStreamBriefInfo::new);
    }

    @Override
    public PageResult<InlongStreamInfo> listAll(InlongStreamPageRequest request) {
        LOGGER.debug("begin to list full inlong stream page by {}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"request is empty");
        String groupId = request.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.checkNotNull((Object)groupEntity, (String)("inlong group not found by groupId=" + groupId));
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page page = (Page)this.streamMapper.selectByCondition(request);
        List streamInfoList = CommonBeanUtils.copyListProperties((List)page, InlongStreamInfo::new);
        for (InlongStreamInfo streamInfo : streamInfoList) {
            String streamId = streamInfo.getInlongStreamId();
            InlongStreamExtParam.unpackExtParams((InlongStreamInfo)streamInfo);
            List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
            streamInfo.setFieldList(streamFields);
            List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
            List streamExtInfos = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
            streamInfo.setExtList(streamExtInfos);
            List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
            streamInfo.setSourceList(sourceList);
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            streamInfo.setSinkList(sinkList);
        }
        PageResult pageResult = new PageResult(streamInfoList, Long.valueOf(page.getTotal()), Integer.valueOf(page.getPageNum()), Integer.valueOf(page.getPageSize()));
        LOGGER.debug("success to list full inlong stream info by {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<InlongStreamBriefInfo> listBriefWithSink(String groupId) {
        LOGGER.debug("begin to get inlong stream brief list by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        List entityList = this.streamMapper.selectByGroupId(groupId);
        List briefInfoList = CommonBeanUtils.copyListProperties((List)entityList, InlongStreamBriefInfo::new);
        for (InlongStreamBriefInfo briefInfo : briefInfoList) {
            String streamId = briefInfo.getInlongStreamId();
            List<SinkBriefInfo> sinkList = this.sinkService.listBrief(groupId, streamId);
            briefInfo.setSinkList(sinkList);
        }
        LOGGER.info("success to get inlong stream brief list for groupId={}", (Object)groupId);
        return briefInfoList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to update inlong stream info={}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"inlong stream request is empty");
        String groupId = request.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        return this.updateWithoutCheck(request, operator);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(InlongStreamRequest request, UserInfo opInfo) {
        List<String> inCharges;
        if (request == null) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "inlong stream request is empty");
        }
        if (opInfo == null) {
            throw new BusinessException(ErrorCodeEnum.LOGIN_USER_EMPTY);
        }
        String groupId = request.getInlongGroupId();
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        }
        String streamId = request.getInlongStreamId();
        if (StringUtils.isBlank((CharSequence)streamId)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        }
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        if (!opInfo.getRoles().contains(UserTypeEnum.ADMIN.name()) && !(inCharges = Arrays.asList(entity.getInCharges().split(","))).contains(opInfo.getName())) {
            throw new BusinessException(ErrorCodeEnum.GROUP_PERMISSION_DENIED);
        }
        GroupStatus curState = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.isTempStatus((GroupStatus)curState)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED, String.format("inlong groupId=%s status=%s was not allowed to add/update/delete stream", groupId, curState));
        }
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND, String.format("inlong stream not found by groupId=%s, streamId=%s", groupId, streamId));
        }
        if (!Objects.equals(streamEntity.getVersion(), request.getVersion())) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("stream has already updated with groupId=%s, streamId=%s, curVersion=%s", streamEntity.getInlongGroupId(), streamEntity.getInlongStreamId(), request.getVersion()));
        }
        String extParams = InlongStreamExtParam.packExtParams((InlongStreamRequest)request);
        request.setExtParams(extParams);
        CommonBeanUtils.copyProperties((Object)request, (Object)streamEntity, (boolean)true);
        streamEntity.setModifier(opInfo.getName());
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.streamMapper.updateByIdentifierSelective(streamEntity)) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateField(groupId, streamId, request.getFieldList());
        List extList = request.getExtList();
        this.saveOrUpdateExt(groupId, streamId, extList);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean updateWithoutCheck(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to update inlong stream without check, request={}", (Object)request);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        String errMsg = String.format("stream has already updated with groupId=%s, streamId=%s, curVersion=%s", streamEntity.getInlongGroupId(), streamEntity.getInlongStreamId(), request.getVersion());
        if (!Objects.equals(streamEntity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        String extParams = InlongStreamExtParam.packExtParams((InlongStreamRequest)request);
        request.setExtParams(extParams);
        CommonBeanUtils.copyProperties((Object)request, (Object)streamEntity, (boolean)true);
        streamEntity.setModifier(operator);
        int rowCount = this.streamMapper.updateByIdentifierSelective(streamEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateField(groupId, streamId, request.getFieldList());
        List extList = request.getExtList();
        this.saveOrUpdateExt(groupId, streamId, extList);
        LOGGER.info("success to update inlong stream without check for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(String groupId, String streamId, String operator) {
        LOGGER.debug("begin to delete inlong stream, groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        InlongStreamEntity entity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (entity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        Integer sourceCount = this.sourceService.getCount(groupId, streamId);
        if (sourceCount > 0) {
            LOGGER.error("inlong stream has undeleted sources, delete failed");
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SOURCE);
        }
        int sinkCount = this.sinkService.getCount(groupId, streamId);
        if (sinkCount > 0) {
            LOGGER.error("inlong stream has undeleted sinks, delete failed");
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SINK);
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.streamMapper.updateByPrimaryKey(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("stream has already updated with group id={}, stream id={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("begin to delete inlong stream field, streamId={}", (Object)streamId);
        this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
        this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
        LOGGER.info("success to delete inlong stream, ext property and fields for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(String groupId, String streamId, UserInfo opInfo) {
        List<String> inCharges;
        if (opInfo == null) {
            throw new BusinessException(ErrorCodeEnum.LOGIN_USER_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)streamId)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        }
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        if (groupEntity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        if (!opInfo.getRoles().contains(UserTypeEnum.ADMIN.name()) && !(inCharges = Arrays.asList(groupEntity.getInCharges().split(","))).contains(opInfo.getName())) {
            throw new BusinessException(ErrorCodeEnum.GROUP_PERMISSION_DENIED);
        }
        GroupStatus curState = GroupStatus.forCode((int)groupEntity.getStatus());
        if (GroupStatus.isTempStatus((GroupStatus)curState)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED, String.format("inlong groupId=%s status=%s was not allowed to add/update/delete stream", groupId, curState));
        }
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        if (this.sourceService.getCount(groupId, streamId) > 0) {
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SOURCE);
        }
        if (this.sinkService.getCount(groupId, streamId) > 0) {
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SINK);
        }
        streamEntity.setIsDeleted(streamEntity.getId());
        streamEntity.setModifier(opInfo.getName());
        if (this.streamMapper.updateByPrimaryKey(streamEntity) != InlongConstants.AFFECTED_ONE_ROW.intValue()) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
        this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean logicDeleteAll(String groupId, String operator) {
        LOGGER.debug("begin to delete all inlong stream by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        List entityList = this.streamMapper.selectByGroupId(groupId);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            LOGGER.info("inlong stream not found by groupId={}", (Object)groupId);
            return true;
        }
        for (InlongStreamEntity entity : entityList) {
            entity.setIsDeleted(entity.getId());
            entity.setModifier(operator);
            int rowCount = this.streamMapper.updateByIdentifierSelective(entity);
            if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                LOGGER.error("stream has already updated with group id={}, stream id={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getVersion()});
                throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
            }
            String streamId = entity.getInlongStreamId();
            this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
            this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
            this.sourceService.logicDeleteAll(groupId, streamId, operator);
            this.sinkService.logicDeleteAll(groupId, streamId, operator);
        }
        LOGGER.info("success to delete all inlong stream, ext property and fields by groupId={}", (Object)groupId);
        return true;
    }

    @Override
    public int selectCountByGroupId(String groupId) {
        LOGGER.debug("begin to get count by groupId={}", (Object)groupId);
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return 0;
        }
        int count = this.streamMapper.selectCountByGroupId(groupId);
        LOGGER.info("success to get count");
        return count;
    }

    @Override
    public List<InlongStreamBriefInfo> getTopicList(String groupId) {
        LOGGER.debug("begin bo get topic list by group id={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        List topicList = this.streamMapper.selectBriefList(groupId);
        LOGGER.debug("success to get topic list by groupId={}, result size={}", (Object)groupId, (Object)topicList.size());
        return topicList;
    }

    @Override
    public boolean updateAfterApprove(List<InlongStreamApproveRequest> streamApproveList, String operator) {
        if (CollectionUtils.isEmpty(streamApproveList)) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update stream after approve={}", streamApproveList);
        }
        String groupId = null;
        for (InlongStreamApproveRequest info : streamApproveList) {
            groupId = info.getInlongGroupId();
            InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, info.getInlongStreamId());
            streamEntity.setStatus(StreamStatus.CONFIG_ING.getCode());
            int rowCount = this.streamMapper.updateByIdentifierSelective(streamEntity);
            if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                LOGGER.error("stream has already updated with group id={}, stream id={}, curVersion={}", new Object[]{streamEntity.getInlongGroupId(), streamEntity.getInlongStreamId(), streamEntity.getVersion()});
                throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
            }
            this.sinkService.updateAfterApprove(info.getSinkList(), operator);
        }
        LOGGER.info("success to update stream after approve for groupId={}", groupId);
        return true;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean updateStatus(String groupId, String streamId, Integer status, String operator) {
        this.streamMapper.updateStatusByIdentifier(groupId, streamId, status, operator);
        LOGGER.info("success to update stream after approve for groupId=" + groupId + ", streamId=" + streamId);
        return true;
    }

    @Override
    public void insertDlqOrRlq(String groupId, String topicName, String operator) {
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, topicName);
        if (count >= 1) {
            LOGGER.error("DLQ/RLQ topic already exists with name={}", (Object)topicName);
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE, "DLQ/RLQ topic already exists");
        }
        InlongStreamEntity streamEntity = new InlongStreamEntity();
        streamEntity.setInlongGroupId(groupId);
        streamEntity.setInlongStreamId(topicName);
        streamEntity.setMqResource(topicName);
        streamEntity.setDescription("This is DLQ / RLQ topic created by SYSTEM");
        streamEntity.setDailyRecords(Integer.valueOf(1000));
        streamEntity.setDailyStorage(Integer.valueOf(1000));
        streamEntity.setPeakRecords(Integer.valueOf(1000));
        streamEntity.setMaxLength(Integer.valueOf(1000));
        streamEntity.setStatus(StreamStatus.CONFIG_SUCCESSFUL.getCode());
        streamEntity.setCreator(operator);
        streamEntity.setModifier(operator);
        this.streamMapper.insert(streamEntity);
    }

    @Override
    public void logicDeleteDlqOrRlq(String groupId, String topicName, String operator) {
        this.streamMapper.logicDeleteDlqOrRlq(groupId, topicName, operator);
        LOGGER.info("success to logic delete dlq or rlq by groupId={}, topicName={}", (Object)groupId, (Object)topicName);
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateField(String groupId, String streamId, List<StreamField> fieldList) {
        LOGGER.debug("begin to update inlong stream field, groupId={}, streamId={}, field={}", new Object[]{groupId, streamId, fieldList});
        try {
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            this.saveField(groupId, streamId, fieldList);
            LOGGER.info("success to update inlong stream field for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            LOGGER.error("failed to update inlong stream field: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.STREAM_FIELD_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveField(String groupId, String streamId, List<StreamField> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        infoList.forEach(streamField -> streamField.setId(null));
        List list = CommonBeanUtils.copyListProperties(infoList, InlongStreamFieldEntity::new);
        for (InlongStreamFieldEntity entity : list) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
            entity.setIsDeleted(InlongConstants.UN_DELETED);
        }
        this.streamFieldMapper.insertAll(list);
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveOrUpdateExt(String groupId, String streamId, List<InlongStreamExtInfo> exts) {
        LOGGER.info("begin to save or update inlong stream ext info, groupId={}, streamId={}, ext={}", new Object[]{groupId, streamId, exts});
        if (CollectionUtils.isEmpty(exts)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(exts, InlongStreamExtEntity::new);
        entityList.forEach(streamEntity -> {
            streamEntity.setInlongGroupId(groupId);
            streamEntity.setInlongStreamId(streamId);
        });
        this.streamExtMapper.insertOnDuplicateKeyUpdate(entityList);
        LOGGER.info("success to save or update inlong stream ext for groupId={}", (Object)groupId);
    }

    private InlongGroupEntity checkGroupStatusIsTemp(String groupId) {
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.checkNotNull((Object)entity, (String)"groupId is invalid");
        GroupStatus curState = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.isTempStatus((GroupStatus)curState)) {
            LOGGER.error("inlong groupId={} status={} was not allowed to add/update/delete stream", (Object)groupId, (Object)curState);
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED);
        }
        return entity;
    }
}

