/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.inlong.common.pojo.sdk.SortSourceConfigResponse;
import org.apache.inlong.common.pojo.sortstandalone.SortClusterResponse;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.sort.SortStatusInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusRequest;
import org.apache.inlong.manager.service.core.SortClusterService;
import org.apache.inlong.manager.service.core.SortService;
import org.apache.inlong.manager.service.core.SortSourceService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.plugin.sort.PollerPlugin;
import org.apache.inlong.manager.workflow.plugin.sort.SortPoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SortServiceImpl
implements SortService,
PluginBinder {
    private static final Logger log = LoggerFactory.getLogger(SortServiceImpl.class);
    @Lazy
    @Autowired
    private SortSourceService sortSourceService;
    @Lazy
    @Autowired
    private SortClusterService sortClusterService;
    @Autowired
    private InlongGroupService groupService;
    private SortPoller sortPoller;

    @Override
    public SortClusterResponse getClusterConfig(String clusterName, String md5) {
        return this.sortClusterService.getClusterConfig(clusterName, md5);
    }

    @Override
    public SortSourceConfigResponse getSourceConfig(String clusterName, String sortTaskId, String md5) {
        return this.sortSourceService.getSourceConfig(clusterName, sortTaskId, md5);
    }

    @Override
    public List<SortStatusInfo> listSortStatus(SortStatusRequest request) {
        Preconditions.expectNotNull((Object)this.sortPoller, (String)"sort status poller not initialized, please try later");
        try {
            List groupInfoList = request.getInlongGroupIds().stream().map(groupId -> {
                try {
                    return this.groupService.get((String)groupId);
                }
                catch (Exception e) {
                    log.error("can not get groupId: {}, skip it", groupId, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            List statusInfos = this.sortPoller.pollSortStatus(groupInfoList, request.getCredentials());
            log.debug("success to list sort status for request={}, result={}", (Object)request, (Object)statusInfos);
            return statusInfos;
        }
        catch (Exception e) {
            log.error("poll sort status error: ", (Throwable)e);
            throw new BusinessException("poll sort status error: " + e.getMessage());
        }
    }

    public void acceptPlugin(Plugin plugin) {
        if (plugin instanceof PollerPlugin) {
            PollerPlugin pollerPlugin = (PollerPlugin)plugin;
            this.sortPoller = pollerPlugin.getSortPoller();
        }
    }
}

