/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupUtils;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitGroupCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(InitGroupCompleteListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private StreamSourceService sourceService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute InitGroupCompleteListener for groupId={}", (Object)groupId);
        try {
            InlongGroupInfo groupInfo = form.getGroupInfo();
            String operator = context.getOperator();
            Integer nextStatus = InlongGroupUtils.isBatchTask((InlongGroupInfo)form.getGroupInfo()) ? GroupStatus.FINISH.getCode() : GroupStatus.CONFIG_SUCCESSFUL.getCode();
            this.groupService.updateStatus(groupId, nextStatus, operator);
            InlongGroupEntity existGroup = this.groupMapper.selectByGroupId(groupId);
            InlongGroupRequest updateGroupRequest = groupInfo.genRequest();
            updateGroupRequest.setVersion(existGroup.getVersion());
            this.groupService.update(updateGroupRequest, operator);
            this.streamService.updateStatus(groupId, null, StreamStatus.CONFIG_SUCCESSFUL.getCode(), operator);
            if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(groupInfo.getEnableCreateResource())) {
                if (InlongConstants.LIGHTWEIGHT_MODE.equals(groupInfo.getLightweight())) {
                    this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_NORMAL.getCode(), operator);
                } else {
                    this.sourceService.updateStatus(groupId, null, SourceStatus.TO_BE_ISSUED_ADD.getCode(), operator);
                }
            }
            log.info("success to execute InitGroupCompleteListener for groupId={}", (Object)groupId);
            return ListenerResult.success();
        }
        catch (Exception e) {
            throw new WorkflowListenerException((Throwable)e);
        }
    }
}

