/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeDTO;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeInfo;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.mysql.MySQLJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MySQLDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "MYSQL";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        MySQLDataNodeInfo dataNodeInfo = new MySQLDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)dataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            MySQLDataNodeDTO dto = MySQLDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)dataNodeInfo);
        }
        return dataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        MySQLDataNodeRequest dataNodeRequest = (MySQLDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)dataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            MySQLDataNodeDTO dto = MySQLDataNodeDTO.getFromRequest((MySQLDataNodeRequest)dataNodeRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for MySQL node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        Boolean bl;
        block8: {
            String jdbcUrl = MySQLDataNodeDTO.convertToJdbcurl((String)request.getUrl());
            String username = request.getUsername();
            String password = request.getToken();
            Preconditions.expectNotBlank((String)jdbcUrl, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection jdbcUrl cannot be empty");
            Connection ignored = MySQLJdbcUtils.getConnection(jdbcUrl, username, password);
            try {
                LOGGER.info("mysql connection not null - connection success for jdbcUrl={}, username={}, password={}", new Object[]{jdbcUrl, username, password});
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String errMsg = String.format("mysql connection failed for jdbcUrl=%s, username=%s, password=%s", jdbcUrl, username, password);
                    LOGGER.error(errMsg, (Throwable)e);
                    throw new BusinessException(errMsg);
                }
            }
            ignored.close();
        }
        return bl;
    }

    @Override
    public void updateRelatedStreamSource(DataNodeRequest request, DataNodeEntity entity, String operator) {
        boolean changed;
        MySQLDataNodeRequest mySQLDataNodeRequest = (MySQLDataNodeRequest)request;
        MySQLDataNodeInfo mySQLDataNodeInfo = (MySQLDataNodeInfo)this.getFromEntity(entity);
        boolean bl = changed = !Objects.equals(mySQLDataNodeRequest.getUrl(), mySQLDataNodeInfo.getUrl()) || !Objects.equals(mySQLDataNodeRequest.getBackupUrl(), mySQLDataNodeInfo.getBackupUrl()) || !Objects.equals(mySQLDataNodeRequest.getUsername(), mySQLDataNodeInfo.getUsername()) || !Objects.equals(mySQLDataNodeRequest.getToken(), mySQLDataNodeInfo.getToken());
        if (changed) {
            this.retryStreamSourceByDataNodeNameAndType(request.getName(), "MYSQL_SQL", operator);
        }
    }
}

