/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeDTO;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeInfo;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "REDIS";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        RedisDataNodeInfo redisDataNodeInfo = new RedisDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)redisDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            RedisDataNodeDTO dto = RedisDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)redisDataNodeInfo);
        }
        return redisDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        RedisDataNodeRequest redisDataNodeRequest = (RedisDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)redisDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            RedisDataNodeDTO dto = RedisDataNodeDTO.getFromRequest((RedisDataNodeRequest)redisDataNodeRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Redis node: %s", e.getMessage()));
        }
    }
}

