/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hudi;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.inlong.manager.pojo.sink.hudi.HudiColumnInfo;
import org.apache.inlong.manager.pojo.sink.hudi.HudiTableInfo;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiTypeConverter;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudiCatalogClient {
    private static final Logger LOG = LoggerFactory.getLogger(HudiCatalogClient.class);
    private final String uri;
    private final String dbName;
    private final String warehouse;
    private IMetaStoreClient client;
    private final HiveConf hiveConf;

    public HudiCatalogClient(String uri, String warehouse, String dbName) throws MetaException {
        this.uri = uri;
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.hiveConf = new HiveConf();
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, uri);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, false);
    }

    public void open() {
        if (this.client == null) {
            try {
                this.client = Hive.get((HiveConf)this.hiveConf).getMSC();
            }
            catch (Exception e) {
                throw new HoodieCatalogException("Failed to create hive metastore client", (Throwable)e);
            }
            LOG.info("Connected to Hive metastore");
        }
    }

    private void createDatabase(String warehouse, Map<String, String> meta, boolean ignoreIfExists) {
        Database database = new Database();
        HashMap parameter = Maps.newHashMap();
        database.setName(this.dbName);
        database.setLocationUri(new Path(warehouse, this.dbName) + ".db");
        meta.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
            database.setParameters(parameter);
        });
        try {
            this.client.createDatabase(database);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new RuntimeException("Database '" + this.dbName + "' already exist!");
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create database '" + this.dbName + "'", e);
        }
    }

    public void createDatabase(String warehouse, boolean ignoreIfExists) {
        this.createDatabase(warehouse, Maps.newHashMap(), ignoreIfExists);
    }

    public boolean tableExist(String tableName) throws TException {
        return this.client.tableExists(this.dbName, tableName);
    }

    public List<HudiColumnInfo> getColumns(String dbName, String tableName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.client.getTable(dbName, tableName);
        List allCols = hiveTable.getSd().getCols().stream().filter(s -> !HoodieAvroUtils.isMetadataField((String)s.getName())).collect(Collectors.toList());
        return allCols.stream().map(s -> {
            HudiColumnInfo info = new HudiColumnInfo();
            info.setName(s.getName());
            info.setType(s.getType());
            return info;
        }).collect(Collectors.toList());
    }

    public void addColumns(String tableName, List<HudiColumnInfo> columns) throws TException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.client.getTable(this.dbName, tableName);
        org.apache.hadoop.hive.metastore.api.Table newHiveTable = hiveTable.deepCopy();
        List cols = newHiveTable.getSd().getCols();
        for (HudiColumnInfo column : columns) {
            FieldSchema fieldSchema = new FieldSchema();
            fieldSchema.setName(column.getName());
            fieldSchema.setType(column.getType());
            fieldSchema.setComment(column.getDesc());
            cols.add(fieldSchema);
        }
        newHiveTable.getSd().setCols(cols);
        this.client.alter_table(this.dbName, tableName, newHiveTable);
    }

    public void createTable(String tableName, HudiTableInfo tableInfo, boolean useRealTimeInputFormat) throws TException, IOException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = Table.getEmptyTable((String)this.dbName, (String)tableName);
        hiveTable.setOwner(UserGroupInformation.getCurrentUser().getUserName());
        hiveTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        HashMap<String, String> properties = new HashMap<String, String>();
        String location = this.warehouse + "/" + this.dbName + ".db/" + tableName;
        properties.put("path", location);
        List cols = tableInfo.getColumns().stream().map(column -> {
            FieldSchema fieldSchema = new FieldSchema();
            fieldSchema.setName(column.getName());
            fieldSchema.setType(HudiTypeConverter.convert(column));
            fieldSchema.setComment(column.getDesc());
            return fieldSchema;
        }).collect(Collectors.toList());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(cols);
        hiveTable.setDbName(this.dbName);
        hiveTable.setTableName(tableName);
        HoodieFileFormat baseFileFormat = HoodieFileFormat.PARQUET;
        String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName((HoodieFileFormat)baseFileFormat, (boolean)useRealTimeInputFormat);
        String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName((HoodieFileFormat)baseFileFormat);
        String serDeClassName = HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)baseFileFormat);
        sd.setInputFormat(inputFormatClassName);
        sd.setOutputFormat(outputFormatClassName);
        HashMap<String, String> serdeProperties = new HashMap<String, String>();
        serdeProperties.put("path", location);
        serdeProperties.put("hoodie.query.as.ro.table", String.valueOf(!useRealTimeInputFormat));
        sd.setSerdeInfo(new SerDeInfo(null, serDeClassName, serdeProperties));
        sd.setLocation(location);
        hiveTable.setSd(sd);
        hiveTable.setParameters(properties);
        this.client.createTable(hiveTable);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            LOG.info("Disconnect to hive metastore");
        }
    }
}

