/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.iceberg;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergColumnInfo;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergSinkDTO;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.iceberg.IcebergCatalogUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcebergResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergResourceOperator.class);
    private static final String CATALOG_TYPE_HIVE = "HIVE";
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "ICEBERG".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private IcebergSinkDTO getIcebergInfo(SinkInfo sinkInfo) {
        IcebergSinkDTO icebergInfo = IcebergSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        if (StringUtils.isBlank((CharSequence)icebergInfo.getCatalogUri()) && CATALOG_TYPE_HIVE.equals(icebergInfo.getCatalogType())) {
            String dataNodeName = sinkInfo.getDataNodeName();
            Preconditions.expectNotBlank((String)dataNodeName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"iceberg catalog uri not specified and data node is empty");
            IcebergDataNodeInfo dataNodeInfo = (IcebergDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)icebergInfo);
            icebergInfo.setCatalogUri(dataNodeInfo.getUrl());
        }
        return icebergInfo;
    }

    private void createTable(SinkInfo sinkInfo) {
        LOGGER.info("begin to create iceberg table for sinkInfo={}", (Object)sinkInfo);
        IcebergSinkDTO icebergInfo = this.getIcebergInfo(sinkInfo);
        List<IcebergColumnInfo> columnInfoList = this.getColumnList(sinkInfo);
        if (CollectionUtils.isEmpty(columnInfoList)) {
            throw new IllegalArgumentException("no iceberg columns specified");
        }
        IcebergTableInfo tableInfo = IcebergSinkDTO.getIcebergTableInfo((IcebergSinkDTO)icebergInfo, columnInfoList);
        String metastoreUri = icebergInfo.getCatalogUri();
        String warehouse = icebergInfo.getWarehouse();
        String dbName = icebergInfo.getDbName();
        String tableName = icebergInfo.getTableName();
        try {
            IcebergCatalogUtils.createDb(metastoreUri, warehouse, dbName);
            boolean tableExists = IcebergCatalogUtils.tableExists(metastoreUri, dbName, tableName);
            if (!tableExists) {
                IcebergCatalogUtils.createTable(metastoreUri, warehouse, tableInfo);
            } else {
                List<IcebergColumnInfo> existColumns = IcebergCatalogUtils.getColumns(metastoreUri, dbName, tableName);
                List<IcebergColumnInfo> needAddColumns = tableInfo.getColumns().stream().skip(existColumns.size()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    IcebergCatalogUtils.addColumns(metastoreUri, dbName, tableName, needAddColumns);
                    LOGGER.info("{} columns added for table {}", (Object)needAddColumns.size(), (Object)tableName);
                }
            }
            String info = "success to create iceberg resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo = {}", (Object)info);
        }
        catch (Throwable e) {
            String errMsg = "create iceberg table failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }

    private List<IcebergColumnInfo> getColumnList(SinkInfo sinkInfo) {
        List fieldList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        ArrayList<IcebergColumnInfo> columnList = new ArrayList<IcebergColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            IcebergColumnInfo column = IcebergColumnInfo.getFromJson((String)field.getExtParams());
            column.setName(field.getFieldName());
            column.setType(field.getFieldType());
            column.setDesc(field.getFieldComment());
            column.setRequired(field.getIsRequired() != null && field.getIsRequired() > 0);
            columnList.add(column);
        }
        return columnList;
    }
}

