/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.ck;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.pojo.node.ck.ClickHouseDataNodeDTO;
import org.apache.inlong.manager.pojo.node.ck.ClickHouseDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseFieldInfo;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseSink;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseSinkDTO;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClickHouseSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickHouseSinkOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "CLICKHOUSE".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "CLICKHOUSE";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        ClickHouseSinkRequest sinkRequest = (ClickHouseSinkRequest)request;
        try {
            ClickHouseSinkDTO dto = ClickHouseSinkDTO.getFromRequest((ClickHouseSinkRequest)sinkRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of ClickHouse SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSink getFromEntity(@NotNull StreamSinkEntity entity) {
        ClickHouseSink sink = new ClickHouseSink();
        if (entity == null) {
            return sink;
        }
        ClickHouseSinkDTO dto = ClickHouseSinkDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getJdbcUrl())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.ILLEGAL_RECORD_FIELD_VALUE, "clickhouse jdbc url unspecified and data node is empty");
            }
            ClickHouseDataNodeInfo dataNodeInfo = (ClickHouseDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(entity.getDataNodeName(), entity.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
            dto.setJdbcUrl(ClickHouseDataNodeDTO.convertToJdbcUrl((String)dataNodeInfo.getUrl()));
            dto.setPassword(dataNodeInfo.getToken());
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = super.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }

    @Override
    public void saveFieldOpt(SinkRequest request) {
        List fieldList = request.getSinkFieldList();
        LOGGER.debug("begin to save es sink fields={}", (Object)fieldList);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return;
        }
        int size = fieldList.size();
        ArrayList<StreamSinkFieldEntity> entityList = new ArrayList<StreamSinkFieldEntity>(size);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sinkType = request.getSinkType();
        Integer sinkId = request.getId();
        for (SinkField fieldInfo : fieldList) {
            this.checkFieldInfo(fieldInfo);
            StreamSinkFieldEntity fieldEntity = (StreamSinkFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamSinkFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            try {
                ClickHouseFieldInfo dto = ClickHouseFieldInfo.getFromRequest((SinkField)fieldInfo);
                fieldEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            }
            catch (Exception e) {
                throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of ClickHouse FieldInfo failure: %s", e.getMessage()));
            }
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setSinkType(sinkType);
            fieldEntity.setSinkId(sinkId);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.sinkFieldMapper.insertAll(entityList);
        LOGGER.debug("success to save es sink fields");
    }

    @Override
    public List<SinkField> getSinkFields(Integer sinkId) {
        List sinkFieldEntities = this.sinkFieldMapper.selectBySinkId(sinkId);
        ArrayList<SinkField> fieldList = new ArrayList<SinkField>();
        if (CollectionUtils.isEmpty((Collection)sinkFieldEntities)) {
            return fieldList;
        }
        sinkFieldEntities.forEach(field -> {
            SinkField sinkField = new SinkField();
            if (StringUtils.isNotBlank((CharSequence)field.getExtParams())) {
                ClickHouseFieldInfo clickHouseFieldInfo = ClickHouseFieldInfo.getFromJson((String)field.getExtParams());
                CommonBeanUtils.copyProperties((Object)field, (Object)clickHouseFieldInfo, (boolean)true);
                fieldList.add((SinkField)clickHouseFieldInfo);
            } else {
                CommonBeanUtils.copyProperties((Object)field, (Object)sinkField, (boolean)true);
                fieldList.add(sinkField);
            }
        });
        return fieldList;
    }
}

