/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.postgresql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.tdsqlpostgresql.TDSQLPostgreSQLSink;
import org.apache.inlong.manager.pojo.sink.tdsqlpostgresql.TDSQLPostgreSQLSinkDTO;
import org.apache.inlong.manager.pojo.sink.tdsqlpostgresql.TDSQLPostgreSQLSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDSQLPostgreSQLSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TDSQLPostgreSQLSinkOperator.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "TDSQLPOSTGRESQL".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "TDSQLPOSTGRESQL";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        TDSQLPostgreSQLSinkRequest sinkRequest = (TDSQLPostgreSQLSinkRequest)request;
        try {
            TDSQLPostgreSQLSinkDTO dto = TDSQLPostgreSQLSinkDTO.getFromRequest((TDSQLPostgreSQLSinkRequest)sinkRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of TDSQLPostgreSQL SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        TDSQLPostgreSQLSink sink = new TDSQLPostgreSQLSink();
        if (entity == null) {
            return sink;
        }
        TDSQLPostgreSQLSinkDTO dto = TDSQLPostgreSQLSinkDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = super.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }
}

