/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.kafka.KafkaOffset;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSource;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSourceDTO;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSourceRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KafkaSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private InlongClusterService clusterService;

    @Override
    public Boolean accept(String sourceType) {
        return "KAFKA".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "KAFKA";
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        KafkaSourceRequest sourceRequest = (KafkaSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            KafkaSourceDTO dto = KafkaSourceDTO.getFromRequest((KafkaSourceRequest)sourceRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Kafka SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        KafkaSource source = new KafkaSource();
        if (entity == null) {
            return source;
        }
        KafkaSourceDTO dto = KafkaSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }

    @Override
    public Map<String, List<StreamSource>> getSourcesMap(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfos, List<StreamSource> streamSources) {
        ClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "KAFKA");
        KafkaClusterInfo kafkaClusterInfo = (KafkaClusterInfo)clusterInfo;
        String bootstrapServers = kafkaClusterInfo.getUrl();
        HashMap sourceMap = Maps.newHashMap();
        streamInfos.forEach(streamInfo -> {
            String topicName;
            KafkaSource kafkaSource = new KafkaSource();
            String streamId = streamInfo.getInlongStreamId();
            kafkaSource.setSourceName(streamId);
            kafkaSource.setBootstrapServers(bootstrapServers);
            kafkaSource.setTopic(streamInfo.getMqResource());
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataType())) {
                String serializationType = DataTypeEnum.forType((String)streamInfo.getDataType()).getType();
                kafkaSource.setSerializationType(serializationType);
            }
            if (StringUtils.isBlank((CharSequence)(topicName = streamInfo.getMqResource())) || topicName.equals(streamId)) {
                topicName = String.format("%s.%s", groupInfo.getMqResource(), streamInfo.getMqResource());
            }
            kafkaSource.setTopic(topicName);
            kafkaSource.setIgnoreParseError(streamInfo.getIgnoreParseError().booleanValue());
            for (StreamSource sourceInfo : streamSources) {
                if (!Objects.equals(streamId, sourceInfo.getInlongStreamId()) || !StringUtils.isEmpty((CharSequence)kafkaSource.getSerializationType()) || !StringUtils.isNotEmpty((CharSequence)sourceInfo.getSerializationType())) continue;
                kafkaSource.setSerializationType(sourceInfo.getSerializationType());
            }
            if (StringUtils.isBlank((CharSequence)kafkaSource.getSerializationType())) {
                kafkaSource.setSerializationType(DataTypeEnum.CSV.getType());
            }
            if (DataTypeEnum.CSV.getType().equalsIgnoreCase(kafkaSource.getSerializationType())) {
                kafkaSource.setDataSeparator(streamInfo.getDataSeparator());
                if (StringUtils.isBlank((CharSequence)kafkaSource.getDataSeparator())) {
                    kafkaSource.setDataSeparator(String.valueOf(44));
                }
            }
            kafkaSource.setWrapWithInlongMsg(streamInfo.getWrapWithInlongMsg().booleanValue());
            kafkaSource.setAutoOffsetReset(KafkaOffset.EARLIEST.getName());
            kafkaSource.setFieldList(streamInfo.getFieldList());
            sourceMap.computeIfAbsent(streamId, key -> Lists.newArrayList()).add(kafkaSource);
        });
        return sourceMap;
    }
}

