/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.user;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.DateUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.util.RSAUtils;
import org.apache.inlong.manager.common.util.SHAUtils;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.dao.mapper.UserEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserLoginLockStatus;
import org.apache.inlong.manager.pojo.user.UserLoginRequest;
import org.apache.inlong.manager.pojo.user.UserRequest;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final Integer SECRET_KEY_SIZE = 16;
    private static final Integer LOCKED_TIME = 3;
    private static final Integer LOCKED_THRESHOLD = 10;
    private final Map<String, UserLoginLockStatus> loginLockStatusMap = new ConcurrentHashMap<String, UserLoginLockStatus>();
    @Autowired
    private UserEntityMapper userMapper;

    @Override
    public Integer save(UserRequest request, String currentUser) {
        String username = request.getName();
        UserEntity userExists = this.userMapper.selectByName(username);
        String password = request.getPassword();
        Preconditions.expectNull((Object)userExists, (String)("username [" + username + "] already exists"));
        Preconditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"password cannot be blank");
        UserEntity entity = new UserEntity();
        entity.setName(username);
        entity.setPassword(SHAUtils.encrypt((String)password));
        entity.setAccountType(request.getAccountType());
        entity.setDueDate(DateUtils.getExpirationDate((Integer)request.getValidDays()));
        entity.setCreator(currentUser);
        entity.setModifier(currentUser);
        entity.setExtParams(request.getExtParams());
        try {
            Map keyPairs = RSAUtils.generateRSAKeyPairs();
            String publicKey = (String)keyPairs.get("RSAPublicKey");
            String privateKey = (String)keyPairs.get("RSAPrivateKey");
            String secretKey = RandomStringUtils.randomAlphanumeric((int)SECRET_KEY_SIZE);
            Integer encryptVersion = AESUtils.getCurrentVersion(null);
            entity.setEncryptVersion(encryptVersion);
            entity.setPublicKey(AESUtils.encryptToString((byte[])publicKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
            entity.setPrivateKey(AESUtils.encryptToString((byte[])privateKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
            entity.setSecretKey(AESUtils.encryptToString((byte[])secretKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
        }
        catch (Exception e) {
            String errMsg = String.format("generate rsa key error: %s", e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
        Preconditions.expectTrue((this.userMapper.insert(entity) > 0 ? 1 : 0) != 0, (String)"Create user failed");
        LOGGER.debug("success to create user info={}", (Object)request);
        return entity.getId();
    }

    @Override
    public UserInfo getById(Integer userId, String currentUser) {
        Preconditions.expectNotNull((Object)userId, (String)"User id cannot be null");
        UserEntity entity = this.userMapper.selectById(userId);
        Preconditions.expectNotNull((Object)entity, (String)("User not exists with id " + userId));
        UserEntity curUser = this.userMapper.selectByName(currentUser);
        Preconditions.expectTrue((Objects.equals(UserTypeEnum.ADMIN.getCode(), curUser.getAccountType()) || Objects.equals(entity.getName(), currentUser) ? 1 : 0) != 0, (String)"Current user does not have permission to get other users' info");
        UserInfo result = new UserInfo();
        result.setId(entity.getId());
        result.setName(entity.getName());
        result.setValidDays(DateUtils.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        result.setAccountType(entity.getAccountType());
        result.setVersion(entity.getVersion());
        if (StringUtils.isNotBlank((CharSequence)entity.getSecretKey()) && StringUtils.isNotBlank((CharSequence)entity.getPublicKey())) {
            try {
                Integer version = entity.getEncryptVersion();
                byte[] secretKeyBytes = AESUtils.decryptAsString((String)entity.getSecretKey(), (Integer)version);
                byte[] publicKeyBytes = AESUtils.decryptAsString((String)entity.getPublicKey(), (Integer)version);
                result.setSecretKey(new String(secretKeyBytes, StandardCharsets.UTF_8));
                result.setPublicKey(new String(publicKeyBytes, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                String errMsg = String.format("decryption error: %s", e.getMessage());
                LOGGER.error(errMsg, (Throwable)e);
                throw new BusinessException(errMsg);
            }
        }
        LOGGER.debug("success to get user info by id={}", (Object)userId);
        return result;
    }

    @Override
    public UserInfo getByName(String name) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"User name cannot be null");
        UserEntity entity = this.userMapper.selectByName(name);
        if (entity == null) {
            return null;
        }
        UserInfo userInfo = (UserInfo)CommonBeanUtils.copyProperties((Object)entity, UserInfo::new);
        userInfo.setValidDays(DateUtils.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        return userInfo;
    }

    @Override
    public PageResult<UserInfo> list(UserRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.userMapper.selectByCondition(request);
        List userList = CommonBeanUtils.copyListProperties((List)entityPage, UserInfo::new);
        userList.forEach(entity -> entity.setStatus(entity.getDueDate().after(new Date()) ? "valid" : "invalid"));
        PageResult pageResult = new PageResult(userList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        LOGGER.debug("success to list users for request={}, result size={}", (Object)request, (Object)pageResult.getTotal());
        return pageResult;
    }

    @Override
    public Integer update(UserRequest request, String currentUser) {
        LOGGER.debug("begin to update user info={} by {}", (Object)request, (Object)currentUser);
        Preconditions.expectNotNull((Object)request, (String)"Userinfo cannot be null");
        Preconditions.expectNotNull((Object)request.getId(), (String)"User id cannot be null");
        UserEntity currentUserEntity = this.userMapper.selectByName(currentUser);
        String updateName = request.getName();
        boolean isAdmin = Objects.equals(UserTypeEnum.ADMIN.getCode(), currentUserEntity.getAccountType());
        Preconditions.expectTrue((isAdmin || Objects.equals(updateName, currentUser) ? 1 : 0) != 0, (String)"You are not a manager and do not have permission to update other users");
        boolean managerToOrdinary = isAdmin && Objects.equals(UserTypeEnum.OPERATOR.getCode(), request.getAccountType()) && Objects.equals(currentUser, updateName);
        Preconditions.expectFalse((boolean)managerToOrdinary, (String)"You are a manager and you cannot change to an ordinary user");
        UserEntity updateUserEntity = this.userMapper.selectById(request.getId());
        Preconditions.expectNotNull((Object)updateUserEntity, (String)("User not exists with id=" + request.getId()));
        String errMsg = String.format("user has already updated with username=%s, reqVersion=%s, storedVersion=%s", updateName, request.getVersion(), updateUserEntity.getVersion());
        if (!Objects.equals(updateUserEntity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        UserEntity targetUserEntity = this.userMapper.selectByName(updateName);
        Preconditions.expectTrue((Objects.isNull(targetUserEntity) || Objects.equals(targetUserEntity.getName(), updateUserEntity.getName()) ? 1 : 0) != 0, (String)("Username [" + updateName + "] already exists"));
        if (!isAdmin) {
            String oldPassword = request.getPassword();
            String oldPasswordHash = SHAUtils.encrypt((String)oldPassword);
            Preconditions.expectTrue((boolean)oldPasswordHash.equals(updateUserEntity.getPassword()), (String)"Old password is wrong");
            Integer validDays = DateUtils.getValidDays((Date)updateUserEntity.getCreateTime(), (Date)updateUserEntity.getDueDate());
            Preconditions.expectTrue((request.getValidDays() <= validDays ? 1 : 0) != 0, (String)"Ordinary users are not allowed to add valid days");
            Preconditions.expectTrue((boolean)Objects.equals(updateUserEntity.getAccountType(), request.getAccountType()), (String)"Ordinary users are not allowed to update account type");
        }
        if (!StringUtils.isBlank((CharSequence)request.getNewPassword())) {
            String newPasswordHash = SHAUtils.encrypt((String)request.getNewPassword());
            updateUserEntity.setPassword(newPasswordHash);
        }
        updateUserEntity.setDueDate(DateUtils.getExpirationDate((Integer)request.getValidDays()));
        updateUserEntity.setAccountType(request.getAccountType());
        updateUserEntity.setName(updateName);
        updateUserEntity.setExtParams(request.getExtParams());
        int rowCount = this.userMapper.updateByPrimaryKeySelective(updateUserEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("success to update user info={} by {}", (Object)request, (Object)currentUser);
        return updateUserEntity.getId();
    }

    @Override
    public Boolean delete(Integer userId, String currentUser) {
        Preconditions.expectNotNull((Object)userId, (String)"User id should not be empty");
        UserEntity curUser = this.userMapper.selectByName(currentUser);
        UserEntity entity = this.userMapper.selectById(userId);
        Preconditions.expectTrue((boolean)curUser.getAccountType().equals(UserTypeEnum.ADMIN.getCode()), (String)"Current user is not a manager and does not have permission to delete users");
        Preconditions.expectTrue((!Objects.equals(entity.getName(), currentUser) ? 1 : 0) != 0, (String)"Current user does not have permission to delete himself");
        this.userMapper.deleteById(userId);
        LOGGER.debug("success to delete user by id={}, current user={}", (Object)userId, (Object)currentUser);
        return true;
    }

    @Override
    public void login(UserLoginRequest req) {
        String username = req.getUsername();
        UserLoginLockStatus userLoginLockStatus = this.loginLockStatusMap.getOrDefault(username, new UserLoginLockStatus());
        LocalDateTime lockoutTime = userLoginLockStatus.getLockoutTime();
        if (lockoutTime != null && lockoutTime.isAfter(LocalDateTime.now())) {
            long waitMinutes = Duration.between(LocalDateTime.now(), lockoutTime).toMinutes() + 1L;
            throw new BusinessException("account has been locked, please try again in " + waitMinutes + " minutes");
        }
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, req.getPassword());
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (AuthenticationException e) {
            LOGGER.error("login error for request {}", (Object)req, (Object)e);
            int loginErrorCount = userLoginLockStatus.getLoginErrorCount() + 1;
            if (loginErrorCount % LOCKED_THRESHOLD == 0) {
                LocalDateTime lockedTime = LocalDateTime.now().plusMinutes(LOCKED_TIME.intValue());
                userLoginLockStatus.setLockoutTime(lockedTime);
                LOGGER.error("account {} is locked, lockout time: {}", (Object)username, (Object)lockedTime);
            }
            userLoginLockStatus.setLoginErrorCount(loginErrorCount);
            this.loginLockStatusMap.put(username, userLoginLockStatus);
            throw e;
        }
        LoginUserUtils.setUserLoginInfo((UserInfo)subject.getPrincipal());
        userLoginLockStatus.setLoginErrorCount(0);
        this.loginLockStatusMap.put(username, userLoginLockStatus);
    }

    @Override
    public void checkUser(String inCharges, String user, String errMsg) {
        UserEntity userEntity = this.userMapper.selectByName(user);
        boolean isInCharge = Preconditions.inSeparatedString((String)user, (String)inCharges, (String)",");
        Preconditions.expectTrue((isInCharge || UserTypeEnum.ADMIN.getCode().equals(userEntity.getAccountType()) ? 1 : 0) != 0, (String)errMsg);
    }
}

