/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterDTO;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterInfo;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentClusterOperator
extends AbstractClusterOperator {
    private static final Logger log = LoggerFactory.getLogger(AgentClusterOperator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentClusterOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "AGENT";
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        AgentClusterInfo agentInfo = new AgentClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)agentInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            AgentClusterDTO dto = AgentClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)agentInfo);
        }
        LOGGER.debug("success to get agent cluster info from entity");
        return agentInfo;
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        AgentClusterRequest agentRequest = (AgentClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)agentRequest, (Object)targetEntity, (boolean)true);
        try {
            AgentClusterDTO dto = AgentClusterDTO.getFromRequest((AgentClusterRequest)agentRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.debug("success to set entity for agent cluster");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Agent Cluster failure: %s", e.getMessage()));
        }
    }
}

