/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.es.ElasticsearchClusterDTO;
import org.apache.inlong.manager.pojo.cluster.es.ElasticsearchClusterInfo;
import org.apache.inlong.manager.pojo.cluster.es.ElasticsearchClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchClusterOperator
extends AbstractClusterOperator {
    @Autowired
    private ObjectMapper mapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "ELASTICSEARCH";
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        ElasticsearchClusterRequest esRequest = (ElasticsearchClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)esRequest, (Object)targetEntity, (boolean)true);
        try {
            ElasticsearchClusterDTO dto = ElasticsearchClusterDTO.getFromRequest((ElasticsearchClusterRequest)esRequest);
            targetEntity.setExtParams(this.mapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Elasticsearch Cluster failure: %s", e.getMessage()));
        }
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        ElasticsearchClusterInfo info = new ElasticsearchClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)info);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            ElasticsearchClusterDTO dto = ElasticsearchClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)info);
        }
        return info;
    }
}

