/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowApproverEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowApproverEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.workflow.ApproverPageRequest;
import org.apache.inlong.manager.pojo.workflow.ApproverRequest;
import org.apache.inlong.manager.pojo.workflow.ApproverResponse;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionService;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowApproverServiceImpl
implements WorkflowApproverService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowApproverServiceImpl.class);
    @Autowired
    private WorkflowApproverEntityMapper approverMapper;
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @Override
    public Integer save(ApproverRequest request, String operator) {
        LOGGER.info("begin to save approver: {} by user: {}", (Object)request, (Object)operator);
        WorkflowProcess process = this.processDefinitionService.getByName(request.getProcessName());
        Preconditions.expectNotNull((Object)process, (String)("process not exit with name: " + request.getProcessName()));
        WorkflowTask task = process.getTaskByName(request.getTaskName());
        Preconditions.expectNotNull((Object)task, (String)("task not exit with name: " + request.getTaskName()));
        Preconditions.expectTrue((boolean)(task instanceof UserTask), (String)"task should be UserTask");
        ApproverPageRequest pageRequest = ApproverPageRequest.builder().processName(request.getProcessName()).taskName(request.getTaskName()).build();
        List exist = this.approverMapper.selectByCondition(pageRequest);
        Preconditions.expectEmpty((Collection)exist, (String)"workflow approver already exits");
        WorkflowApproverEntity entity = (WorkflowApproverEntity)CommonBeanUtils.copyProperties((Object)request, WorkflowApproverEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.approverMapper.insert(entity);
        LOGGER.info("success to save approver: {} by user: {}", (Object)request, (Object)operator);
        return entity.getId();
    }

    @Override
    public ApproverResponse get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"approver id cannot be null");
        WorkflowApproverEntity approverEntity = this.approverMapper.selectById(id);
        if (approverEntity == null) {
            LOGGER.error("workflow approver not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.WORKFLOW_APPROVER_NOT_FOUND);
        }
        return (ApproverResponse)CommonBeanUtils.copyProperties((Object)approverEntity, ApproverResponse::new);
    }

    @Override
    public List<String> getApprovers(String processName, String taskName) {
        ApproverPageRequest pageRequest = ApproverPageRequest.builder().processName(processName).taskName(taskName).build();
        List approverEntities = this.approverMapper.selectByCondition(pageRequest);
        HashSet resultSet = new HashSet();
        approverEntities.forEach(entity -> resultSet.addAll(Arrays.asList(entity.getApprovers().split(","))));
        return new ArrayList<String>(resultSet);
    }

    @Override
    public PageResult<ApproverResponse> listByCondition(ApproverPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page page = (Page)this.approverMapper.selectByCondition(request);
        List resultList = CommonBeanUtils.copyListProperties((List)page, ApproverResponse::new);
        return new PageResult(resultList, Long.valueOf(page.getTotal()), Integer.valueOf(page.getPageNum()), Integer.valueOf(page.getPageSize()));
    }

    @Override
    public Integer update(ApproverRequest request, String operator) {
        Preconditions.expectNotNull((Object)request, (String)"approver request cannot be null");
        Integer id = request.getId();
        Preconditions.expectNotNull((Object)id, (String)"approver id cannot be null");
        WorkflowApproverEntity entity = this.approverMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (String)("not exist with id:" + id));
        String errMsg = String.format("approver has already updated with id=%s, process=%s, task=%s, curVersion=%s", id, request.getProcessName(), request.getTaskName(), request.getVersion());
        if (!Objects.equals(entity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        entity.setModifier(operator);
        entity.setApprovers(request.getApprovers());
        this.approverMapper.updateById(entity);
        LOGGER.info("success to update workflow approver for request: {} by user: {}", (Object)request, (Object)operator);
        return id;
    }

    @Override
    public void delete(Integer id, String operator) {
        WorkflowApproverEntity entity = this.approverMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (String)("not exist with id:" + id));
        int success = this.approverMapper.deleteByPrimaryKey(id, operator);
        Preconditions.expectTrue((success == 1 ? 1 : 0) != 0, (String)"delete failed");
    }
}

