/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.group.InlongGroupOperator;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractGroupOperator
implements InlongGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGroupOperator.class);
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected InlongStreamService streamService;
    @Autowired
    protected InlongClusterService clusterService;
    @Autowired
    protected InlongGroupEntityMapper groupMapper;
    @Autowired
    protected InlongGroupExtEntityMapper groupExtMapper;
    @Autowired
    protected InlongStreamExtEntityMapper streamExtMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String saveOpt(InlongGroupRequest request, String operator) {
        String groupId = request.getInlongGroupId();
        InlongGroupEntity entity = (InlongGroupEntity)CommonBeanUtils.copyProperties((Object)request, InlongGroupEntity::new);
        if (StringUtils.isEmpty((CharSequence)entity.getMqResource())) {
            entity.setMqResource(groupId);
        }
        this.setTargetEntity(request, entity);
        entity.setStatus(GroupStatus.TO_BE_SUBMIT.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.groupMapper.insert(entity);
        return groupId;
    }

    protected abstract void setTargetEntity(InlongGroupRequest var1, InlongGroupEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(InlongGroupRequest request, String operator) {
        InlongGroupEntity entity = (InlongGroupEntity)CommonBeanUtils.copyProperties((Object)request, InlongGroupEntity::new);
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        int rowCount = this.groupMapper.updateByIdentifierSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("record has already updated with group id=%s, curVersion=%d", request.getInlongGroupId(), request.getVersion()));
        }
    }
}

