/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import java.util.Arrays;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.UserEntityMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupCheckService {
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private UserEntityMapper userMapper;

    public InlongGroupEntity checkGroupStatus(String groupId, String operator) {
        InlongGroupEntity inlongGroupEntity = this.groupMapper.selectByGroupId(groupId);
        if (inlongGroupEntity == null) {
            throw new BusinessException(String.format("InlongGroup does not exist with InlongGroupId=%s", groupId));
        }
        UserEntity userEntity = this.userMapper.selectByName(operator);
        List<String> managers = Arrays.asList(inlongGroupEntity.getInCharges().split(","));
        Preconditions.expectTrue((managers.contains(operator) || UserTypeEnum.ADMIN.getCode().equals(userEntity.getAccountType()) ? 1 : 0) != 0, (String)String.format(ErrorCodeEnum.USER_IS_NOT_MANAGER.getMessage(), operator, managers));
        GroupStatus status = GroupStatus.forCode((int)inlongGroupEntity.getStatus());
        if (GroupStatus.notAllowedUpdate((GroupStatus)status)) {
            throw new BusinessException(String.format(ErrorCodeEnum.OPT_NOT_ALLOWED_BY_STATUS.getMessage(), status));
        }
        return inlongGroupEntity;
    }
}

