/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.ck;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.ck.ClickHouseDataNodeDTO;
import org.apache.inlong.manager.pojo.node.ck.ClickHouseDataNodeInfo;
import org.apache.inlong.manager.pojo.node.ck.ClickHouseDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.ck.ClickHouseJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClickHouseDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickHouseDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "CLICKHOUSE";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        ClickHouseDataNodeInfo ckDataNodeInfo = new ClickHouseDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)ckDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            ClickHouseDataNodeDTO dto = ClickHouseDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)ckDataNodeInfo);
        }
        return ckDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        ClickHouseDataNodeRequest ckDataNodeRequest = (ClickHouseDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)ckDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            ClickHouseDataNodeDTO dto = ClickHouseDataNodeDTO.getFromRequest((ClickHouseDataNodeRequest)ckDataNodeRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for ClickHouse node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        Boolean bl;
        block8: {
            String url = ClickHouseDataNodeDTO.convertToJdbcUrl((String)request.getUrl());
            String username = request.getUsername();
            String password = request.getToken();
            Preconditions.expectNotBlank((String)url, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection url cannot be empty");
            Connection ignored = ClickHouseJdbcUtils.getConnection(url, username, password);
            try {
                LOGGER.info("clickhouse connection not null - connection success for url={}, username={}, password={}", new Object[]{url, username, password});
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String errMsg = String.format("clickhouse connection failed for url=%s, username=%s, password=%s", url, username, password);
                    LOGGER.error(errMsg, (Throwable)e);
                    throw new BusinessException(errMsg);
                }
            }
            ignored.close();
        }
        return bl;
    }
}

