/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.kudu;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.kudu.KuduDataNodeDTO;
import org.apache.inlong.manager.pojo.node.kudu.KuduDataNodeInfo;
import org.apache.inlong.manager.pojo.node.kudu.KuduDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.kudu.KuduResourceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KuduDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuduDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "KUDU";
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        KuduDataNodeRequest kuduRequest = (KuduDataNodeRequest)request;
        String masters = kuduRequest.getMasters();
        if (StringUtils.isBlank((CharSequence)masters)) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, "masters can not be empty!");
        }
        if (masters.contains(";")) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, "masters can not contain comma!");
        }
        CommonBeanUtils.copyProperties((Object)kuduRequest, (Object)targetEntity, (boolean)true);
        try {
            KuduDataNodeDTO dto = KuduDataNodeDTO.getFromRequest((KuduDataNodeRequest)kuduRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Kudu node: %s", e.getMessage()));
        }
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        KuduDataNodeInfo info = new KuduDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)info);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            KuduDataNodeDTO dto = KuduDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)info);
        }
        return info;
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        KuduDataNodeRequest kuduRequest = (KuduDataNodeRequest)request;
        String masters = kuduRequest.getMasters();
        Preconditions.expectNotBlank((String)masters, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"masters cannot be empty");
        KuduResourceClient kuduClient = new KuduResourceClient(masters);
        try {
            kuduClient.getTablesList();
            LOGGER.info("kudu connection not null - connection success for masters={}", (Object)masters);
            Boolean bl = true;
            kuduClient.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    kuduClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                String errMsg = String.format("kudu connection failed for masters=%s", masters);
                LOGGER.error(errMsg, (Throwable)e);
                throw new BusinessException(errMsg);
            }
        }
    }
}

