/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source;

import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongStreamFieldEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceFieldEntity;
import org.apache.inlong.manager.dao.mapper.InlongStreamFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceFieldEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.StreamSourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSourceOperator
implements StreamSourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSourceOperator.class);
    @Autowired
    protected StreamSourceEntityMapper sourceMapper;
    @Autowired
    protected StreamSourceFieldEntityMapper sourceFieldMapper;
    @Autowired
    protected InlongStreamFieldEntityMapper streamFieldMapper;

    protected abstract String getSourceType();

    protected abstract void setTargetEntity(SourceRequest var1, StreamSourceEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(SourceRequest request, Integer groupStatus, String operator) {
        StreamSourceEntity entity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        if ("AUTO_PUSH".equals(request.getSourceType())) {
            entity.setStatus(SourceStatus.SOURCE_NORMAL.getCode());
        } else if (GroupStatus.forCode((int)groupStatus).equals((Object)GroupStatus.CONFIG_SUCCESSFUL)) {
            entity.setStatus(SourceStatus.TO_BE_ISSUED_ADD.getCode());
        } else {
            entity.setStatus(SourceStatus.SOURCE_NEW.getCode());
        }
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.setTargetEntity(request, entity);
        this.sourceMapper.insert(entity);
        this.saveFieldOpt(entity, request.getFieldList());
        return entity.getId();
    }

    @Override
    public List<StreamField> getSourceFields(Integer sourceId) {
        List sourceFieldEntities = this.sourceFieldMapper.selectBySourceId(sourceId);
        return CommonBeanUtils.copyListProperties((List)sourceFieldEntities, StreamField::new);
    }

    @Override
    public PageResult<? extends StreamSource> getPageInfo(Page<StreamSourceEntity> entityPage) {
        if (CollectionUtils.isEmpty(entityPage)) {
            return PageResult.empty();
        }
        List streamSources = entityPage.stream().map(this::getFromEntity).collect(Collectors.toList());
        return new PageResult(streamSources, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.size()));
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(SourceRequest request, Integer groupStatus, Integer groupMode, String operator) {
        int rowCount;
        boolean allowUpdate;
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(request.getId());
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_NOT_FOUND, String.format("not found source record by id=%d", request.getId()));
        }
        if ("AUTO_PUSH".equals(entity.getSourceType())) {
            this.updateFieldOpt(entity, request.getFieldList());
            return;
        }
        boolean bl = allowUpdate = InlongConstants.LIGHTWEIGHT_MODE.equals(groupMode) || SourceStatus.ALLOWED_UPDATE.contains(entity.getStatus());
        if (!allowUpdate) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_OPT_NOT_ALLOWED, String.format("source=%s is not allowed to update, please wait until its changed to final status or stop / frozen / delete it firstly", entity));
        }
        String errMsg = String.format("source has already updated with groupId=%s, streamId=%s, name=%s, curVersion=%s", request.getInlongGroupId(), request.getInlongStreamId(), request.getSourceName(), request.getVersion());
        if (!Objects.equals(entity.getVersion(), request.getVersion())) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, errMsg);
        }
        if (!Objects.equals(entity.getSourceType(), request.getSourceType())) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, String.format("source type=%s cannot change to %s", entity.getSourceType(), request.getSourceType()));
        }
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sourceName = request.getSourceName();
        List sourceList = this.sourceMapper.selectByRelatedId(groupId, streamId, sourceName);
        for (StreamSourceEntity sourceEntity : sourceList) {
            Integer sourceId = sourceEntity.getId();
            if (Objects.equals(sourceId, request.getId())) continue;
            throw new BusinessException(ErrorCodeEnum.SOURCE_ALREADY_EXISTS, String.format("source name=%s already exists with the groupId=%s streamId=%s", sourceName, groupId, streamId));
        }
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        entity.setPreviousStatus(entity.getStatus());
        if (InlongConstants.STANDARD_MODE.equals(groupMode)) {
            SourceStatus sourceStatus = SourceStatus.forCode((int)entity.getStatus());
            Integer nextStatus = entity.getStatus();
            if (GroupStatus.forCode((int)groupStatus).equals((Object)GroupStatus.CONFIG_SUCCESSFUL)) {
                nextStatus = SourceStatus.TO_BE_ISSUED_RETRY.getCode();
            } else {
                switch (SourceStatus.forCode((int)entity.getStatus())) {
                    case SOURCE_NORMAL: 
                    case HEARTBEAT_TIMEOUT: {
                        nextStatus = SourceStatus.TO_BE_ISSUED_RETRY.getCode();
                        break;
                    }
                    case SOURCE_FAILED: {
                        nextStatus = SourceStatus.SOURCE_NEW.getCode();
                        break;
                    }
                }
            }
            entity.setStatus(nextStatus);
        }
        if ((rowCount = this.sourceMapper.updateByPrimaryKeySelective(entity)) != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, errMsg);
        }
        this.updateFieldOpt(entity, request.getFieldList());
        LOGGER.debug("success to update source of type={}", (Object)request.getSourceType());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void stopOpt(SourceRequest request, String operator) {
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceStatus curState = SourceStatus.forCode((int)existEntity.getStatus());
        SourceStatus nextState = SourceStatus.TO_BE_ISSUED_STOP;
        if (curState == SourceStatus.SOURCE_STOP) {
            return;
        }
        if (!SourceStatus.isAllowedTransition((SourceStatus)curState, (SourceStatus)nextState)) {
            throw new BusinessException(String.format("current source status=%s for id=%s is not allowed to stop", existEntity.getStatus(), existEntity.getId()));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        int rowCount = this.sourceMapper.updateByPrimaryKeySelective(curEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("source has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{curEntity.getInlongGroupId(), curEntity.getInlongStreamId(), curEntity.getSourceName(), curEntity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void restartOpt(SourceRequest request, String operator) {
        SourceStatus nextState;
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceStatus curState = SourceStatus.forCode((int)existEntity.getStatus());
        if (!SourceStatus.isAllowedTransition((SourceStatus)curState, (SourceStatus)(nextState = SourceStatus.TO_BE_ISSUED_ACTIVE))) {
            throw new BusinessException(String.format("current source status=%s for id=%s is not allowed to restart", existEntity.getStatus(), existEntity.getId()));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        int rowCount = this.sourceMapper.updateByPrimaryKeySelective(curEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("source has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{curEntity.getInlongGroupId(), curEntity.getInlongStreamId(), curEntity.getSourceName(), curEntity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }

    protected void updateFieldOpt(StreamSourceEntity entity, List<StreamField> fieldInfos) {
        Integer sourceId = entity.getId();
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return;
        }
        this.sourceFieldMapper.deleteAll(sourceId);
        this.saveFieldOpt(entity, fieldInfos);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
        this.saveStreamField(groupId, streamId, fieldInfos);
        LOGGER.debug("success to update source fields");
    }

    protected void saveStreamField(String groupId, String streamId, List<StreamField> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        infoList.forEach(streamField -> streamField.setId(null));
        List list = CommonBeanUtils.copyListProperties(infoList, InlongStreamFieldEntity::new);
        for (InlongStreamFieldEntity entity : list) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
            entity.setIsDeleted(InlongConstants.UN_DELETED);
        }
        this.streamFieldMapper.insertAll(list);
    }

    protected void saveFieldOpt(StreamSourceEntity entity, List<StreamField> fieldInfos) {
        LOGGER.debug("begin to save source fields={}", fieldInfos);
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return;
        }
        int size = fieldInfos.size();
        ArrayList<StreamSourceFieldEntity> entityList = new ArrayList<StreamSourceFieldEntity>(size);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        String sourceType = entity.getSourceType();
        Integer sourceId = entity.getId();
        for (StreamField fieldInfo : fieldInfos) {
            StreamSourceFieldEntity fieldEntity = (StreamSourceFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamSourceFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setSourceId(sourceId);
            fieldEntity.setSourceType(sourceType);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.sourceFieldMapper.insertAll(entityList);
        LOGGER.debug("success to save source fields");
    }

    protected String getSerializationType(StreamSource streamSource, String streamDataType) {
        if (StringUtils.isNotBlank((CharSequence)streamSource.getSerializationType())) {
            return streamSource.getSerializationType();
        }
        return DataTypeEnum.forType((String)streamDataType).getType();
    }
}

