/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterDTO;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.apache.inlong.manager.service.resource.queue.pulsar.PulsarUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PulsarClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarClusterOperator.class);
    private static final String SERVICE_URL_PREFIX = "pulsar://";
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "PULSAR";
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        PulsarClusterInfo pulsarInfo = new PulsarClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)pulsarInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            PulsarClusterDTO dto = PulsarClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)pulsarInfo);
        }
        return pulsarInfo;
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        PulsarClusterRequest pulsarRequest = (PulsarClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)pulsarRequest, (Object)targetEntity, (boolean)true);
        try {
            PulsarClusterDTO dto = PulsarClusterDTO.getFromRequest((PulsarClusterRequest)pulsarRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.debug("success to set entity for pulsar cluster");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Pulsar Cluster failure: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(ClusterRequest request) {
        PulsarClusterRequest pulsarRequest = (PulsarClusterRequest)request;
        PulsarClusterInfo pulsarInfo = new PulsarClusterInfo();
        CommonBeanUtils.copyProperties((Object)pulsarRequest, (Object)pulsarInfo);
        this.testConnectServiceUrl(pulsarInfo.getUrl());
        return this.testConnectAdminUrl(pulsarInfo);
    }

    @Override
    public Object getClusterInfo(InlongClusterEntity entity) {
        PulsarClusterInfo pulsarClusterInfo = (PulsarClusterInfo)this.getFromEntity(entity);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("serverUrl", pulsarClusterInfo.getUrl());
        map.put("adminUrl", pulsarClusterInfo.getAdminUrl());
        map.put("defaultTenant", pulsarClusterInfo.getPulsarTenant());
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean testConnectAdminUrl(PulsarClusterInfo pulsarInfo) {
        try (PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(pulsarInfo);){
            pulsarAdmin.tenants().getTenants();
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("Pulsar connection failed for AdminUrl=%s", pulsarInfo.getAdminUrl());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }

    private void testConnectServiceUrl(String serviceUrl) {
        Preconditions.expectNotNull((Object)serviceUrl, (String)"Pulsar ServiceUrl is empty");
        Preconditions.expectTrue((boolean)serviceUrl.startsWith(SERVICE_URL_PREFIX), (String)String.format("Pulsar ServiceUrl=%s should starts with %s", serviceUrl, SERVICE_URL_PREFIX));
        String hostPortStr = serviceUrl.replaceAll(SERVICE_URL_PREFIX, "");
        boolean successConnect = Arrays.stream(hostPortStr.split(",")).allMatch(hostPort -> {
            String[] hostPortArr = hostPort.split(":");
            Preconditions.expectTrue((hostPortArr.length >= 2 ? 1 : 0) != 0, (String)String.format("Pulsar ServiceUrl=%s should has ip and port, such as '127.0.0.1:6650'", serviceUrl));
            String host = hostPortArr[0];
            int port = Integer.parseInt(hostPortArr[1]);
            try (Socket socket = new Socket();){
                InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                socket.connect(socketAddress, 30000);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                String errMsg = String.format("Pulsar connection failed for ServiceUrl=%s", hostPort);
                LOGGER.error(errMsg, (Throwable)e);
                return false;
            }
        });
        Preconditions.expectTrue((boolean)successConnect, (String)String.format("Pulsar connection failed for ServiceUrl=%s", hostPortStr));
    }
}

