/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.heartbeat;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.ComponentTypeEnum;
import org.apache.inlong.common.heartbeat.HeartbeatMsg;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ComponentHeartbeatEntity;
import org.apache.inlong.manager.dao.entity.GroupHeartbeatEntity;
import org.apache.inlong.manager.dao.entity.StreamHeartbeatEntity;
import org.apache.inlong.manager.dao.mapper.ComponentHeartbeatEntityMapper;
import org.apache.inlong.manager.dao.mapper.GroupHeartbeatEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamHeartbeatEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.heartbeat.ComponentHeartbeatResponse;
import org.apache.inlong.manager.pojo.heartbeat.GroupHeartbeatResponse;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatPageRequest;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatQueryRequest;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatReportRequest;
import org.apache.inlong.manager.pojo.heartbeat.StreamHeartbeatResponse;
import org.apache.inlong.manager.service.core.HeartbeatService;
import org.apache.inlong.manager.service.heartbeat.HeartbeatManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class HeartbeatServiceImpl
implements HeartbeatService {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatServiceImpl.class);
    private static final Gson GSON = new Gson();
    @Autowired
    @Lazy
    private HeartbeatManager heartbeatManager;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;
    @Autowired
    private ComponentHeartbeatEntityMapper componentHeartbeatMapper;
    @Autowired
    private GroupHeartbeatEntityMapper groupHeartbeatMapper;
    @Autowired
    private StreamHeartbeatEntityMapper streamHeartbeatMapper;

    @Override
    public Boolean reportHeartbeat(HeartbeatReportRequest request) {
        if (request == null || StringUtils.isBlank((CharSequence)request.getComponentType())) {
            log.warn("request is null or component null, just return");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("received heartbeat: " + request);
        }
        this.heartbeatManager.reportHeartbeat((HeartbeatMsg)request);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)request.getComponentType());
        switch (componentType) {
            case Agent: {
                return this.updateAgentHeartbeatOpt(request);
            }
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                return this.updateHeartbeatOpt(request);
            }
        }
        log.error("Unsupported componentType={} for Inlong", (Object)componentType);
        return false;
    }

    @Override
    public ComponentHeartbeatResponse getComponentHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String component = request.getComponent();
        Preconditions.expectNotBlank((String)component, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_INSTANCE_EMPTY);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)component);
        switch (componentType) {
            case Agent: 
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                ComponentHeartbeatEntity res = this.componentHeartbeatMapper.selectByKey(component, request.getInstance());
                return (ComponentHeartbeatResponse)CommonBeanUtils.copyProperties((Object)res, ComponentHeartbeatResponse::new);
            }
        }
        throw new BusinessException("Unsupported component type for " + component);
    }

    @Override
    public GroupHeartbeatResponse getGroupHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String component = request.getComponent();
        Preconditions.expectNotBlank((String)component, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_INSTANCE_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)component);
        switch (componentType) {
            case Agent: 
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                GroupHeartbeatEntity result = this.groupHeartbeatMapper.selectByKey(component, request.getInstance(), request.getInlongGroupId());
                return (GroupHeartbeatResponse)CommonBeanUtils.copyProperties((Object)result, GroupHeartbeatResponse::new);
            }
        }
        throw new BusinessException("Unsupported component type for " + component);
    }

    @Override
    public StreamHeartbeatResponse getStreamHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String component = request.getComponent();
        Preconditions.expectNotBlank((String)component, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_INSTANCE_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongStreamId(), (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)component);
        switch (componentType) {
            case Agent: 
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                StreamHeartbeatEntity result = this.streamHeartbeatMapper.selectByKey(component, request.getInstance(), request.getInlongGroupId(), request.getInlongStreamId());
                return (StreamHeartbeatResponse)CommonBeanUtils.copyProperties((Object)result, StreamHeartbeatResponse::new);
            }
        }
        throw new BusinessException("Unsupported component type for " + component);
    }

    @Override
    public PageResult<ComponentHeartbeatResponse> listComponentHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String component = request.getComponent();
        Preconditions.expectNotBlank((String)component, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)component);
        switch (componentType) {
            case Agent: 
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                return this.listComponentHeartbeatOpt(request);
            }
        }
        throw new BusinessException("Unsupported component type for " + component);
    }

    @Override
    public PageResult<GroupHeartbeatResponse> listGroupHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String component = request.getComponent();
        Preconditions.expectNotBlank((String)component, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)component);
        switch (componentType) {
            case Agent: 
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                return this.listGroupHeartbeatOpt(request);
            }
        }
        throw new BusinessException("Unsupported component type for " + component);
    }

    @Override
    public PageResult<StreamHeartbeatResponse> listStreamHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String component = request.getComponent();
        Preconditions.expectNotBlank((String)component, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        ComponentTypeEnum componentType = ComponentTypeEnum.forType((String)component);
        switch (componentType) {
            case Agent: 
            case Sort: 
            case DataProxy: 
            case Cache: 
            case SDK: {
                return this.listStreamHeartbeatOpt(request);
            }
        }
        throw new BusinessException("Unsupported component type for " + component);
    }

    private Boolean updateAgentHeartbeatOpt(HeartbeatReportRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getGroupHeartbeats()) && StringUtils.isNotBlank((CharSequence)request.getIp())) {
            String agentIp = request.getIp();
            this.sourceMapper.logicalDeleteByAgentIp(agentIp, SourceStatus.SOURCE_DISABLE.getCode(), SourceStatus.SOURCE_NORMAL.getCode());
        }
        return this.updateHeartbeatOpt(request);
    }

    private Boolean updateHeartbeatOpt(HeartbeatReportRequest request) {
        List streamHeartbeats;
        if (log.isDebugEnabled()) {
            log.debug("heartbeat request json = {}", (Object)GSON.toJson((Object)request));
        }
        String component = request.getComponentType();
        String instanceIp = request.getIp();
        Long reportTime = request.getReportTime();
        ComponentHeartbeatEntity entity = new ComponentHeartbeatEntity();
        entity.setComponent(component);
        entity.setInstance(instanceIp);
        entity.setReportTime(reportTime);
        this.componentHeartbeatMapper.insertOrUpdateByKey(entity);
        List groupHeartbeats = request.getGroupHeartbeats();
        if (CollectionUtils.isNotEmpty((Collection)groupHeartbeats)) {
            this.groupHeartbeatMapper.insertOrUpdateAll(component, instanceIp, reportTime, groupHeartbeats);
        }
        if (CollectionUtils.isNotEmpty((Collection)(streamHeartbeats = request.getStreamHeartbeats()))) {
            this.streamHeartbeatMapper.insertOrUpdateAll(component, instanceIp, reportTime, streamHeartbeats);
        }
        return true;
    }

    private PageResult<ComponentHeartbeatResponse> listComponentHeartbeatOpt(HeartbeatPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.componentHeartbeatMapper.selectByCondition(request);
        List responseList = CommonBeanUtils.copyListProperties((List)entityPage, ComponentHeartbeatResponse::new);
        return new PageResult(responseList, Long.valueOf(entityPage.getTotal()));
    }

    private PageResult<GroupHeartbeatResponse> listGroupHeartbeatOpt(HeartbeatPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.groupHeartbeatMapper.selectByCondition(request);
        List responseList = CommonBeanUtils.copyListProperties((List)entityPage, GroupHeartbeatResponse::new);
        return new PageResult(responseList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
    }

    private PageResult<StreamHeartbeatResponse> listStreamHeartbeatOpt(HeartbeatPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.streamHeartbeatMapper.selectByCondition(request);
        List responseList = CommonBeanUtils.copyListProperties((List)entityPage, StreamHeartbeatResponse::new);
        return new PageResult(responseList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
    }
}

