/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group.apply;

import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupApproveRequest;
import org.apache.inlong.manager.pojo.workflow.form.task.InlongGroupApproveForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AfterApprovedTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(AfterApprovedTaskListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamService streamService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        InlongGroupApproveForm form = (InlongGroupApproveForm)context.getActionContext().getForm();
        InlongGroupApproveRequest approveInfo = form.getGroupApproveInfo();
        String groupId = approveInfo.getInlongGroupId();
        log.info("begin to execute AfterApprovedTaskListener for groupId={}", (Object)groupId);
        this.groupService.updateAfterApprove(approveInfo, context.getOperator());
        this.streamService.updateAfterApprove(form.getStreamApproveInfoList(), context.getOperator());
        log.info("success to execute AfterApprovedTaskListener for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

