/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.message;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.common.enums.DataProxyMsgEncType;
import org.apache.inlong.common.util.Utils;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.message.DeserializeOperator;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PbMsgDeserializeOperator
implements DeserializeOperator {
    private static final Logger log = LoggerFactory.getLogger(PbMsgDeserializeOperator.class);

    @Override
    public boolean accept(DataProxyMsgEncType type) {
        return DataProxyMsgEncType.MSG_ENCODE_TYPE_PB.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage> decodeMsg(InlongStreamInfo streamInfo, byte[] msgBytes, Map<String, String> headers, int index) throws Exception {
        ArrayList<BriefMQMessage> messageList = new ArrayList();
        int compressType = Integer.parseInt(headers.getOrDefault("compressType", "0"));
        byte[] values = msgBytes;
        switch (compressType) {
            case 0: {
                break;
            }
            case 1: {
                values = Utils.gzipDecompress((byte[])msgBytes, (int)0, (int)msgBytes.length);
                break;
            }
            case 2: {
                values = Utils.snappyDecompress((byte[])msgBytes, (int)0, (int)msgBytes.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compress type:" + compressType);
            }
        }
        messageList = this.transformMessageObjs(ProxySdk.MessageObjs.parseFrom((byte[])values), streamInfo, index);
        return messageList;
    }

    private List<BriefMQMessage> transformMessageObjs(ProxySdk.MessageObjs messageObjs, InlongStreamInfo streamInfo, int index) {
        if (null == messageObjs) {
            return null;
        }
        ArrayList<BriefMQMessage> briefMQMessages = new ArrayList<BriefMQMessage>();
        for (ProxySdk.MessageObj messageObj : messageObjs.getMsgsList()) {
            List mapFieldEntries = messageObj.getParamsList();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (ProxySdk.MapFieldEntry mapFieldEntry : mapFieldEntries) {
                headers.put(mapFieldEntry.getKey(), mapFieldEntry.getValue());
            }
            BriefMQMessage briefMQMessage = new BriefMQMessage(Integer.valueOf(index), (String)headers.get("groupId"), (String)headers.get("streamId"), Long.valueOf(messageObj.getMsgTime()), (String)headers.get("clientIp"), new String(messageObj.getBody().toByteArray(), Charset.forName(streamInfo.getDataEncoding())));
            briefMQMessages.add(briefMQMessage);
        }
        return briefMQMessages;
    }
}

