/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.es;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchConfig {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchConfig.class);
    private static RestHighLevelClient highLevelClient;
    @Value(value="${es.index.search.hostname}")
    private String hosts;
    @Value(value="${es.auth.enable}")
    private Boolean authEnable = false;
    @Value(value="${es.auth.user}")
    private String username;
    @Value(value="${es.auth.password}")
    private String password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestHighLevelClient highLevelClient() {
        if (highLevelClient != null) {
            return highLevelClient;
        }
        try {
            Class<RestHighLevelClient> clazz = RestHighLevelClient.class;
            synchronized (RestHighLevelClient.class) {
                if (highLevelClient == null) {
                    String[] hostArrays;
                    ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
                    for (String host : hostArrays = this.hosts.split(";")) {
                        if (!StringUtils.isNotBlank((CharSequence)host)) continue;
                        host = host.trim();
                        hosts.add(HttpHost.create((String)host));
                    }
                    RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
                    this.setEsAuth(clientBuilder);
                    highLevelClient = new RestHighLevelClient(clientBuilder);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            logger.error("get es high level client error", (Throwable)e);
        }
        {
            return highLevelClient;
        }
    }

    private void setEsAuth(RestClientBuilder builder) {
        try {
            logger.info("set es auth of enable={}", (Object)this.authEnable);
            if (this.authEnable.booleanValue()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchConfig.lambda$setEsAuth$0((CredentialsProvider)credentialsProvider, arg_0));
            }
        }
        catch (Exception e) {
            logger.error("set es auth error ", (Throwable)e);
        }
    }

    public String getHosts() {
        return this.hosts;
    }

    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchConfig)) {
            return false;
        }
        ElasticsearchConfig other = (ElasticsearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$authEnable = this.getAuthEnable();
        Boolean other$authEnable = other.getAuthEnable();
        if (this$authEnable == null ? other$authEnable != null : !((Object)this$authEnable).equals(other$authEnable)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $authEnable = this.getAuthEnable();
        result = result * 59 + ($authEnable == null ? 43 : ((Object)$authEnable).hashCode());
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchConfig(hosts=" + this.getHosts() + ", authEnable=" + this.getAuthEnable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$setEsAuth$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

