/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.tenant;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongTenantEntity;
import org.apache.inlong.manager.dao.mapper.InlongTenantEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.tenant.InlongTenantPageRequest;
import org.apache.inlong.manager.pojo.tenant.InlongTenantRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.ApproverRequest;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.tenant.InlongTenantService;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongTenantServiceImpl
implements InlongTenantService {
    private static final Logger log = LoggerFactory.getLogger(InlongTenantServiceImpl.class);
    @Autowired
    private InlongTenantEntityMapper inlongTenantEntityMapper;
    @Autowired
    private TenantRoleService tenantRoleService;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    private ExecutorService executorService = new ScheduledThreadPoolExecutor(1);

    @Override
    public InlongTenantInfo getByName(String name) {
        InlongTenantEntity entity = this.inlongTenantEntityMapper.selectByName(name);
        if (entity == null) {
            log.warn("not found valid inlong tenant by name={}", (Object)name);
            return null;
        }
        return (InlongTenantInfo)CommonBeanUtils.copyProperties((Object)entity, InlongTenantInfo::new);
    }

    @Override
    public Integer save(InlongTenantRequest request) {
        String name = request.getName();
        InlongTenantEntity existEntity = this.inlongTenantEntityMapper.selectByName(name);
        if (existEntity != null) {
            String errMsg = String.format("tenant already exist for name=%s)", name);
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongTenantEntity entity = (InlongTenantEntity)CommonBeanUtils.copyProperties((Object)request, InlongTenantEntity::new);
        String operator = LoginUserUtils.getLoginUser().getName();
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.inlongTenantEntityMapper.insert(entity);
        UserInfo loginUserInfo = LoginUserUtils.getLoginUser();
        this.executorService.submit(() -> {
            loginUserInfo.setTenant(request.getName());
            LoginUserUtils.setUserLoginInfo((UserInfo)loginUserInfo);
            this.saveDefaultWorkflowApprovers(ProcessName.APPLY_GROUP_PROCESS.name(), "ut_admin", operator);
            this.saveDefaultWorkflowApprovers(ProcessName.APPLY_CONSUME_PROCESS.name(), "ut_admin", operator);
            LoginUserUtils.removeUserLoginInfo();
        });
        return entity.getId();
    }

    private Integer saveDefaultWorkflowApprovers(String processName, String taskName, String approver) {
        ApproverRequest request = new ApproverRequest();
        request.setProcessName(processName);
        request.setApprovers(approver);
        request.setTaskName(taskName);
        return this.workflowApproverService.save(request, approver);
    }

    @Override
    public PageResult<InlongTenantInfo> listByCondition(InlongTenantPageRequest request, UserInfo userInfo) {
        if (request.getListByLoginUser().booleanValue()) {
            this.setTargetTenantList(request, userInfo);
        }
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = this.inlongTenantEntityMapper.selectByCondition(request);
        List tenantList = CommonBeanUtils.copyListProperties((List)entityPage, InlongTenantInfo::new);
        PageResult pageResult = new PageResult(tenantList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        return pageResult;
    }

    @Override
    public Boolean update(InlongTenantRequest request) {
        InlongTenantEntity exist = this.inlongTenantEntityMapper.selectByName(request.getName());
        if (exist == null) {
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND, String.format("tenant record not found by name=%s", request.getName()));
        }
        if (!exist.getId().equals(request.getId())) {
            throw new BusinessException(ErrorCodeEnum.RECORD_DUPLICATE, String.format("tenant already exist for name=%s, required id=%s, exist id=%s", request.getName(), request.getId(), exist.getId()));
        }
        InlongTenantEntity entity = (InlongTenantEntity)CommonBeanUtils.copyProperties((Object)request, InlongTenantEntity::new);
        String operator = LoginUserUtils.getLoginUser().getName();
        entity.setModifier(operator);
        int rowCount = this.inlongTenantEntityMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("failure to update tenant with name=%s, request version=%d, updated row=%d", request.getName(), request.getVersion(), rowCount));
        }
        return true;
    }

    @Override
    public Boolean delete(String name) {
        String operator = LoginUserUtils.getLoginUser().getName();
        log.info("begin to delete inlong tenant name={} by user={}", (Object)name, (Object)operator);
        InlongTenantEntity inlongTenantEntity = this.inlongTenantEntityMapper.selectByName(name);
        int success = this.inlongTenantEntityMapper.deleteById(inlongTenantEntity.getId());
        Preconditions.expectTrue((success == 1 ? 1 : 0) != 0, (String)"delete failed");
        log.info("success delete inlong tenant name={} by user={}", (Object)name, (Object)operator);
        return true;
    }

    private void setTargetTenantList(InlongTenantPageRequest request, UserInfo userInfo) {
        if (this.isInlongRoles(userInfo)) {
            request.setTenantList(null);
            return;
        }
        List<String> tenants = this.tenantRoleService.listTenantByUsername(userInfo.getName());
        if (CollectionUtils.isEmpty(tenants)) {
            String errMsg = String.format("user=[%s] doesn't belong to any tenant, please contact administrator and get one tenant at least", userInfo.getName());
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        request.setTenantList(tenants);
    }

    private boolean isInlongRoles(UserInfo userInfo) {
        return userInfo.getRoles().contains("INLONG_ADMIN") || userInfo.getRoles().contains("INLONG_OPERATOR");
    }
}

