/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.user;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongTenantEntity;
import org.apache.inlong.manager.dao.entity.TenantUserRoleEntity;
import org.apache.inlong.manager.dao.mapper.InlongTenantEntityMapper;
import org.apache.inlong.manager.dao.mapper.TenantUserRoleEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.TenantRoleInfo;
import org.apache.inlong.manager.pojo.user.TenantRolePageRequest;
import org.apache.inlong.manager.pojo.user.TenantRoleRequest;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantRoleServiceImpl
implements TenantRoleService {
    private static final Logger log = LoggerFactory.getLogger(TenantRoleServiceImpl.class);
    @Autowired
    private TenantUserRoleEntityMapper tenantUserRoleEntityMapper;
    @Autowired
    private InlongTenantEntityMapper tenantMapper;

    @Override
    public PageResult<TenantRoleInfo> listByCondition(TenantRolePageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = this.tenantUserRoleEntityMapper.listByCondition(request);
        List tenantRoleInfos = CommonBeanUtils.copyListProperties((List)entityPage, TenantRoleInfo::new);
        return new PageResult(tenantRoleInfos, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
    }

    @Override
    public int save(TenantRoleRequest request, String operator) {
        String tenantName = request.getTenant();
        String username = request.getUsername();
        Preconditions.expectNotBlank((String)tenantName, (String)"Failed to save tenant user role, tenant should not be blank");
        Preconditions.expectNotBlank((String)username, (String)"Failed to save tenant user role, user should not be blank");
        Preconditions.expectNotBlank((String)request.getRoleCode(), (String)"Failed to save tenant user role, role code should not be blank");
        InlongTenantEntity tenant = this.tenantMapper.selectByName(tenantName);
        Preconditions.expectNotNull((Object)tenant, (ErrorCodeEnum)ErrorCodeEnum.TENANT_NOT_EXIST, (String)String.format(ErrorCodeEnum.TENANT_NOT_EXIST.getMessage(), tenantName));
        TenantUserRoleEntity entity = (TenantUserRoleEntity)CommonBeanUtils.copyProperties((Object)request, TenantUserRoleEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.tenantUserRoleEntityMapper.insert(entity);
        return entity.getId();
    }

    @Override
    public boolean update(TenantRoleRequest request, String operator) {
        TenantUserRoleEntity exist = this.tenantUserRoleEntityMapper.selectById(request.getId());
        Preconditions.expectNotNull((Object)exist, (ErrorCodeEnum)ErrorCodeEnum.RECORD_NOT_FOUND, (String)String.format("tenant user role record not found by id=%s", request.getId()));
        TenantUserRoleEntity entity = (TenantUserRoleEntity)CommonBeanUtils.copyProperties((Object)request, TenantUserRoleEntity::new);
        entity.setModifier(operator);
        int rowCount = this.tenantUserRoleEntityMapper.updateById(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("fail to update tenant user role with id=%d, request version=%d, updated row=%d", request.getId(), request.getVersion(), rowCount));
        }
        return true;
    }

    @Override
    public TenantRoleInfo get(int id) {
        TenantUserRoleEntity entity = this.tenantUserRoleEntityMapper.selectById(Integer.valueOf(id));
        if (entity == null) {
            log.debug("not found valid tenant role by id={}", (Object)id);
            return null;
        }
        return (TenantRoleInfo)CommonBeanUtils.copyProperties((Object)entity, TenantRoleInfo::new);
    }

    @Override
    public TenantRoleInfo getByUsernameAndTenant(String name, String tenant) {
        TenantUserRoleEntity entity = this.tenantUserRoleEntityMapper.selectByUsernameAndTenant(name, tenant);
        if (entity == null) {
            log.debug("not found valid tenant role for name={}, tenant={}", (Object)name, (Object)tenant);
            return null;
        }
        return (TenantRoleInfo)CommonBeanUtils.copyProperties((Object)entity, TenantRoleInfo::new);
    }

    @Override
    public List<String> listTenantByUsername(String username) {
        return this.tenantUserRoleEntityMapper.listByUsername(username);
    }

    @Override
    public Boolean delete(Integer id) {
        String operator = LoginUserUtils.getLoginUser().getName();
        log.info("begin to delete inlong tenant role id={} by user={}", (Object)id, (Object)operator);
        int success = this.tenantUserRoleEntityMapper.deleteById(id);
        Preconditions.expectTrue((success == 1 ? 1 : 0) != 0, (String)"delete tenant role failed");
        log.info("success delete inlong tenant role id={} by user={}", (Object)id, (Object)operator);
        return true;
    }

    @Override
    public Integer saveDefault(String username, String operator) {
        TenantRoleRequest tenantRoleRequest = new TenantRoleRequest();
        tenantRoleRequest.setTenant("public");
        tenantRoleRequest.setRoleCode("TENANT_OPERATOR");
        tenantRoleRequest.setUsername(username);
        return this.save(tenantRoleRequest, operator);
    }
}

