/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.user;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.DateUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.util.RSAUtils;
import org.apache.inlong.manager.common.util.SHAUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterTagEntity;
import org.apache.inlong.manager.dao.entity.InlongConsumeEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterTagEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongConsumeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.UserEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.consume.InlongConsumePageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserLoginLockStatus;
import org.apache.inlong.manager.pojo.user.UserLoginRequest;
import org.apache.inlong.manager.pojo.user.UserRequest;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final Integer SECRET_KEY_SIZE = 16;
    private static final Integer LOCKED_TIME = 3;
    private static final Integer LOCKED_THRESHOLD = 10;
    private final Map<String, UserLoginLockStatus> loginLockStatusMap = new ConcurrentHashMap<String, UserLoginLockStatus>();
    @Autowired
    private UserEntityMapper userMapper;
    @Autowired
    private TenantRoleService tenantRoleService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private InlongClusterTagEntityMapper clusterTagMapper;
    @Autowired
    private DataNodeEntityMapper dataNodeMapper;
    @Autowired
    private InlongConsumeEntityMapper consumeMapper;

    @Override
    public Integer save(UserRequest request, String currentUser) {
        String username = request.getName();
        UserEntity userExists = this.userMapper.selectByName(username);
        String password = request.getPassword();
        Preconditions.expectNull((Object)userExists, (String)("username [" + username + "] already exists"));
        Preconditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"password cannot be blank");
        UserEntity entity = new UserEntity();
        entity.setName(username);
        entity.setPassword(SHAUtils.encrypt((String)password));
        entity.setAccountType(request.getAccountType());
        entity.setDueDate(DateUtils.getExpirationDate((Integer)request.getValidDays()));
        entity.setCreator(currentUser);
        entity.setModifier(currentUser);
        entity.setExtParams(request.getExtParams());
        try {
            Map keyPairs = RSAUtils.generateRSAKeyPairs();
            String publicKey = (String)keyPairs.get("RSAPublicKey");
            String privateKey = (String)keyPairs.get("RSAPrivateKey");
            String secretKey = RandomStringUtils.randomAlphanumeric((int)SECRET_KEY_SIZE);
            Integer encryptVersion = AESUtils.getCurrentVersion(null);
            entity.setEncryptVersion(encryptVersion);
            entity.setPublicKey(AESUtils.encryptToString((byte[])publicKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
            entity.setPrivateKey(AESUtils.encryptToString((byte[])privateKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
            entity.setSecretKey(AESUtils.encryptToString((byte[])secretKey.getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion));
        }
        catch (Exception e) {
            String errMsg = String.format("generate rsa key error: %s", e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
        Preconditions.expectTrue((this.userMapper.insert(entity) > 0 ? 1 : 0) != 0, (String)"Create user failed");
        Preconditions.expectTrue((this.tenantRoleService.saveDefault(username, currentUser) > 0 ? 1 : 0) != 0, (String)"Add default tenant role failed");
        LOGGER.debug("success to create user info={}", (Object)request);
        return entity.getId();
    }

    @Override
    public UserInfo getById(Integer userId, String currentUser) {
        Preconditions.expectNotNull((Object)userId, (String)"User id cannot be null");
        UserEntity entity = this.userMapper.selectById(userId);
        Preconditions.expectNotNull((Object)entity, (String)("User not exists with id " + userId));
        UserEntity curUser = this.userMapper.selectByName(currentUser);
        Preconditions.expectTrue((Objects.equals(TenantUserTypeEnum.TENANT_ADMIN.getCode(), curUser.getAccountType()) || Objects.equals(entity.getName(), currentUser) ? 1 : 0) != 0, (String)"Current user does not have permission to get other users' info");
        UserInfo result = new UserInfo();
        result.setId(entity.getId());
        result.setName(entity.getName());
        result.setValidDays(DateUtils.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        result.setAccountType(entity.getAccountType());
        result.setVersion(entity.getVersion());
        if (StringUtils.isNotBlank((CharSequence)entity.getSecretKey()) && StringUtils.isNotBlank((CharSequence)entity.getPublicKey())) {
            try {
                Integer version = entity.getEncryptVersion();
                byte[] secretKeyBytes = AESUtils.decryptAsString((String)entity.getSecretKey(), (Integer)version);
                byte[] publicKeyBytes = AESUtils.decryptAsString((String)entity.getPublicKey(), (Integer)version);
                result.setSecretKey(new String(secretKeyBytes, StandardCharsets.UTF_8));
                result.setPublicKey(new String(publicKeyBytes, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                String errMsg = String.format("decryption error: %s", e.getMessage());
                LOGGER.error(errMsg, (Throwable)e);
                throw new BusinessException(errMsg);
            }
        }
        LOGGER.debug("success to get user info by id={}", (Object)userId);
        return result;
    }

    @Override
    public UserInfo getByName(String name) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"User name cannot be null");
        UserEntity entity = this.userMapper.selectByName(name);
        if (entity == null) {
            return null;
        }
        UserInfo userInfo = (UserInfo)CommonBeanUtils.copyProperties((Object)entity, UserInfo::new);
        userInfo.setValidDays(DateUtils.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        return userInfo;
    }

    @Override
    public PageResult<UserInfo> list(UserRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.userMapper.selectByCondition(request);
        List userList = CommonBeanUtils.copyListProperties((List)entityPage, UserInfo::new);
        userList.forEach(entity -> entity.setStatus(entity.getDueDate().after(new Date()) ? "valid" : "invalid"));
        PageResult pageResult = new PageResult(userList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        LOGGER.debug("success to list users for request={}, result size={}", (Object)request, (Object)pageResult.getTotal());
        return pageResult;
    }

    @Override
    public Integer update(UserRequest request, String currentUser) {
        LOGGER.debug("begin to update user info={} by {}", (Object)request, (Object)currentUser);
        Preconditions.expectNotNull((Object)request, (String)"Userinfo cannot be null");
        Preconditions.expectNotNull((Object)request.getId(), (String)"User id cannot be null");
        UserEntity currentUserEntity = this.userMapper.selectByName(currentUser);
        String updateName = request.getName();
        boolean isAdmin = Objects.equals(TenantUserTypeEnum.TENANT_ADMIN.getCode(), currentUserEntity.getAccountType());
        Preconditions.expectTrue((isAdmin || Objects.equals(updateName, currentUser) ? 1 : 0) != 0, (String)"You are not a manager and do not have permission to update other users");
        boolean managerToOrdinary = isAdmin && Objects.equals(TenantUserTypeEnum.TENANT_OPERATOR.getCode(), request.getAccountType()) && Objects.equals(currentUser, updateName);
        Preconditions.expectFalse((boolean)managerToOrdinary, (String)"You are a manager and you cannot change to an ordinary user");
        UserEntity updateUserEntity = this.userMapper.selectById(request.getId());
        Preconditions.expectNotNull((Object)updateUserEntity, (String)("User not exists with id=" + request.getId()));
        String errMsg = String.format("user has already updated with username=%s, reqVersion=%s, storedVersion=%s", updateName, request.getVersion(), updateUserEntity.getVersion());
        if (!Objects.equals(updateUserEntity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        UserEntity targetUserEntity = this.userMapper.selectByName(updateName);
        Preconditions.expectTrue((Objects.isNull(targetUserEntity) || Objects.equals(targetUserEntity.getName(), updateUserEntity.getName()) ? 1 : 0) != 0, (String)("Username [" + updateName + "] already exists"));
        if (!isAdmin) {
            String oldPassword = request.getPassword();
            String oldPasswordHash = SHAUtils.encrypt((String)oldPassword);
            Preconditions.expectTrue((boolean)oldPasswordHash.equals(updateUserEntity.getPassword()), (String)"Old password is wrong");
            Integer validDays = DateUtils.getValidDays((Date)updateUserEntity.getCreateTime(), (Date)updateUserEntity.getDueDate());
            Preconditions.expectTrue((request.getValidDays() <= validDays ? 1 : 0) != 0, (String)"Ordinary users are not allowed to add valid days");
            Preconditions.expectTrue((boolean)Objects.equals(updateUserEntity.getAccountType(), request.getAccountType()), (String)"Ordinary users are not allowed to update account type");
        }
        if (!StringUtils.isBlank((CharSequence)request.getNewPassword())) {
            String newPasswordHash = SHAUtils.encrypt((String)request.getNewPassword());
            updateUserEntity.setPassword(newPasswordHash);
        }
        updateUserEntity.setDueDate(DateUtils.getExpirationDate((Integer)request.getValidDays()));
        updateUserEntity.setAccountType(request.getAccountType());
        updateUserEntity.setName(updateName);
        updateUserEntity.setExtParams(request.getExtParams());
        int rowCount = this.userMapper.updateByPrimaryKeySelective(updateUserEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("success to update user info={} by {}", (Object)request, (Object)currentUser);
        return updateUserEntity.getId();
    }

    @Override
    public Boolean delete(Integer userId, String currentUser) {
        Preconditions.expectNotNull((Object)userId, (String)"User id should not be empty");
        UserEntity curUser = this.userMapper.selectByName(currentUser);
        UserEntity entity = this.userMapper.selectById(userId);
        Preconditions.expectTrue((boolean)curUser.getAccountType().equals(TenantUserTypeEnum.TENANT_ADMIN.getCode()), (String)"Current user is not a manager and does not have permission to delete users");
        Preconditions.expectTrue((!Objects.equals(entity.getName(), currentUser) ? 1 : 0) != 0, (String)"Current user does not have permission to delete himself");
        String userName = entity.getName();
        this.removeInChargeForGroup(userName, currentUser);
        this.removeInChargeForCluster(userName, currentUser);
        this.removeInChargeForClusterTag(userName, currentUser);
        this.removeInChargeForDataNode(userName, currentUser);
        this.removeInChargeForConsume(userName, currentUser);
        this.userMapper.deleteById(userId);
        this.removeUserFromSession(userId, currentUser);
        LOGGER.debug("success to delete user by id={}, current user={}", (Object)userId, (Object)currentUser);
        return true;
    }

    @Override
    public void login(UserLoginRequest req) {
        String username = req.getUsername();
        UserLoginLockStatus userLoginLockStatus = this.loginLockStatusMap.getOrDefault(username, new UserLoginLockStatus());
        LocalDateTime lockoutTime = userLoginLockStatus.getLockoutTime();
        if (lockoutTime != null && lockoutTime.isAfter(LocalDateTime.now())) {
            long waitMinutes = Duration.between(LocalDateTime.now(), lockoutTime).toMinutes() + 1L;
            throw new BusinessException("account has been locked, please try again in " + waitMinutes + " minutes");
        }
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, req.getPassword());
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (AuthenticationException e) {
            LOGGER.error("login error for request {}", (Object)req, (Object)e);
            int loginErrorCount = userLoginLockStatus.getLoginErrorCount() + 1;
            if (loginErrorCount % LOCKED_THRESHOLD == 0) {
                LocalDateTime lockedTime = LocalDateTime.now().plusMinutes(LOCKED_TIME.intValue());
                userLoginLockStatus.setLockoutTime(lockedTime);
                LOGGER.error("account {} is locked, lockout time: {}", (Object)username, (Object)lockedTime);
            }
            userLoginLockStatus.setLoginErrorCount(loginErrorCount);
            this.loginLockStatusMap.put(username, userLoginLockStatus);
            throw e;
        }
        LoginUserUtils.setUserLoginInfo((UserInfo)((UserInfo)subject.getPrincipal()));
        userLoginLockStatus.setLoginErrorCount(0);
        this.loginLockStatusMap.put(username, userLoginLockStatus);
    }

    @Override
    public void checkUser(String inCharges, String user, String errMsg) {
        UserEntity userEntity = this.userMapper.selectByName(user);
        boolean isInCharge = Preconditions.inSeparatedString((String)user, (String)inCharges, (String)",");
        Preconditions.expectTrue((isInCharge || TenantUserTypeEnum.TENANT_ADMIN.getCode().equals(userEntity.getAccountType()) ? 1 : 0) != 0, (String)errMsg);
    }

    public void removeInChargeForGroup(String user, String operator) {
        InlongGroupPageRequest pageRequest = new InlongGroupPageRequest();
        pageRequest.setCurrentUser(user);
        pageRequest.setIsAdminRole(Boolean.valueOf(false));
        for (InlongGroupEntity groupEntity : this.groupMapper.selectByCondition(pageRequest)) {
            if (Objects.equals(groupEntity.getCreator(), user)) {
                groupEntity.setCreator("admin");
            }
            HashSet inChargeSet = Sets.newHashSet((Object[])groupEntity.getInCharges().split(","));
            inChargeSet.remove(user);
            String updateInCharge = Joiner.on((String)",").join((Iterable)inChargeSet);
            groupEntity.setInCharges(updateInCharge);
            groupEntity.setModifier(operator);
            int rowCount = this.groupMapper.updateByIdentifierSelective(groupEntity);
            if (rowCount == InlongConstants.AFFECTED_ONE_ROW) continue;
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("record has already updated with group id=%s, curVersion=%d", groupEntity.getInlongGroupId(), groupEntity.getVersion()));
        }
    }

    public void removeInChargeForCluster(String user, String operator) {
        ClusterPageRequest pageRequest = new ClusterPageRequest();
        pageRequest.setCurrentUser(user);
        pageRequest.setIsAdminRole(Boolean.valueOf(false));
        for (InlongClusterEntity clusterEntity : this.clusterMapper.selectByCondition(pageRequest)) {
            if (Objects.equals(clusterEntity.getCreator(), user)) {
                clusterEntity.setCreator("admin");
            }
            HashSet inChargeSet = Sets.newHashSet((Object[])clusterEntity.getInCharges().split(","));
            inChargeSet.remove(user);
            String updateInCharge = Joiner.on((String)",").join((Iterable)inChargeSet);
            clusterEntity.setInCharges(updateInCharge);
            clusterEntity.setModifier(operator);
            int rowCount = this.clusterMapper.updateByIdSelective(clusterEntity);
            if (rowCount == InlongConstants.AFFECTED_ONE_ROW) continue;
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("cluster has already updated with name=%s, type=%s, curVersion=%d", clusterEntity.getName(), clusterEntity.getType(), clusterEntity.getVersion()));
        }
    }

    public void removeInChargeForClusterTag(String user, String operator) {
        ClusterTagPageRequest pageRequest = new ClusterTagPageRequest();
        pageRequest.setCurrentUser(user);
        pageRequest.setIsAdminRole(Boolean.valueOf(false));
        for (InlongClusterTagEntity clusterTagEntity : this.clusterTagMapper.selectByCondition(pageRequest)) {
            if (Objects.equals(clusterTagEntity.getCreator(), user)) {
                clusterTagEntity.setCreator("admin");
            }
            HashSet inChargeSet = Sets.newHashSet((Object[])clusterTagEntity.getInCharges().split(","));
            inChargeSet.remove(user);
            String updateInCharge = Joiner.on((String)",").join((Iterable)inChargeSet);
            clusterTagEntity.setInCharges(updateInCharge);
            clusterTagEntity.setModifier(operator);
            int rowCount = this.clusterTagMapper.updateByIdSelective(clusterTagEntity);
            if (rowCount == InlongConstants.AFFECTED_ONE_ROW) continue;
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("cluster tag has already updated with name=%s, curVersion=%s", clusterTagEntity.getClusterTag(), clusterTagEntity.getVersion()));
        }
    }

    public void removeInChargeForDataNode(String user, String operator) {
        DataNodePageRequest pageRequest = new DataNodePageRequest();
        pageRequest.setCurrentUser(user);
        pageRequest.setIsAdminRole(Boolean.valueOf(false));
        for (DataNodeEntity dataNodeEntity : this.dataNodeMapper.selectByCondition(pageRequest)) {
            if (Objects.equals(dataNodeEntity.getCreator(), user)) {
                dataNodeEntity.setCreator("admin");
            }
            HashSet inChargeSet = Sets.newHashSet((Object[])dataNodeEntity.getInCharges().split(","));
            inChargeSet.remove(user);
            String updateInCharge = Joiner.on((String)",").join((Iterable)inChargeSet);
            dataNodeEntity.setInCharges(updateInCharge);
            dataNodeEntity.setModifier(operator);
            int rowCount = this.dataNodeMapper.updateByIdSelective(dataNodeEntity);
            if (rowCount == InlongConstants.AFFECTED_ONE_ROW) continue;
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("failure to update data node with name=%s, type=%s, request version=%d, updated row=%d", dataNodeEntity.getName(), dataNodeEntity.getType(), dataNodeEntity.getVersion(), rowCount));
        }
    }

    public void removeInChargeForConsume(String user, String operator) {
        InlongConsumePageRequest pageRequest = new InlongConsumePageRequest();
        pageRequest.setCurrentUser(user);
        pageRequest.setIsAdminRole(Boolean.valueOf(false));
        for (InlongConsumeEntity consumeEntity : this.consumeMapper.selectByCondition(pageRequest)) {
            if (Objects.equals(consumeEntity.getCreator(), user)) {
                consumeEntity.setCreator("admin");
            }
            HashSet inChargeSet = Sets.newHashSet((Object[])consumeEntity.getInCharges().split(","));
            inChargeSet.remove(user);
            String updateInCharge = Joiner.on((String)",").join((Iterable)inChargeSet);
            consumeEntity.setInCharges(updateInCharge);
            consumeEntity.setModifier(operator);
            int rowCount = this.consumeMapper.updateByIdSelective(consumeEntity);
            if (rowCount == InlongConstants.AFFECTED_ONE_ROW) continue;
            LOGGER.error("inlong consume has already updated, id={}, curVersion={}", (Object)consumeEntity.getId(), (Object)consumeEntity.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }

    public void removeUserFromSession(Integer userId, String operator) {
        DefaultWebSecurityManager securityManager = (DefaultWebSecurityManager)SecurityUtils.getSecurityManager();
        DefaultWebSessionManager sessionManager = (DefaultWebSessionManager)securityManager.getSessionManager();
        SessionDAO sessionDAO = sessionManager.getSessionDAO();
        Collection sessions = sessionDAO.getActiveSessions();
        if (sessions.size() >= 1) {
            UserInfo user = null;
            for (Session onlineSession : sessions) {
                Object attribute = onlineSession.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                if (attribute == null || (user = (UserInfo)((SimplePrincipalCollection)attribute).getPrimaryPrincipal()) == null || !Objects.equals(user.getId(), userId)) continue;
                sessionDAO.delete(onlineSession);
                LOGGER.info("success remove user from session by id={}, current user={}", (Object)user.getId(), (Object)operator);
            }
        }
    }
}

