/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeDTO;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeResponse;
import org.apache.inlong.manager.service.cluster.node.AbstractClusterNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentClusterNodeOperator
extends AbstractClusterNodeOperator {
    private static final Logger log = LoggerFactory.getLogger(AgentClusterNodeOperator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentClusterNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterNodeType) {
        return this.getClusterNodeType().equals(clusterNodeType);
    }

    @Override
    public String getClusterNodeType() {
        return "AGENT";
    }

    @Override
    public ClusterNodeResponse getFromEntity(InlongClusterNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        AgentClusterNodeResponse agentClusterNodeResponse = new AgentClusterNodeResponse();
        CommonBeanUtils.copyProperties((Object)entity, (Object)agentClusterNodeResponse);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            AgentClusterNodeDTO dto = AgentClusterNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)agentClusterNodeResponse);
        }
        LOGGER.debug("success to get agent cluster node info from entity");
        return agentClusterNodeResponse;
    }

    @Override
    protected void setTargetEntity(ClusterNodeRequest request, InlongClusterNodeEntity targetEntity) {
        AgentClusterNodeRequest agentNodeRequest = (AgentClusterNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)agentNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            AgentClusterNodeDTO dto = AgentClusterNodeDTO.getFromRequest((AgentClusterNodeRequest)agentNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.debug("success to set entity for agent cluster node");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Agent ClusterNode failure: %s", e.getMessage()));
        }
    }
}

